/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.elasticsearch.search.sort.SortOrder;

public class H2LogQueryDAO
implements ILogQueryDAO {
    private final JDBCHikariCPClient h2Client;
    private final ModuleManager manager;
    private final int maxSizeOfArrayColumn;
    private final int numOfSearchValuesPerTag;
    private List<String> searchableTagKeys;

    public H2LogQueryDAO(JDBCHikariCPClient h2Client, ModuleManager manager, int maxSizeOfArrayColumn, int numOfSearchValuesPerTag) {
        this.h2Client = h2Client;
        this.manager = manager;
        this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
        this.numOfSearchValuesPerTag = numOfSearchValuesPerTag;
    }

    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, String endpointName, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, long startSecondTB, long endSecondTB, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableLogsTags().split(","));
            if (this.searchableTagKeys.size() > this.maxSizeOfArrayColumn) {
                this.searchableTagKeys = this.searchableTagKeys.subList(0, this.maxSizeOfArrayColumn);
            }
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("log").append(" where ");
        sql.append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (StringUtil.isNotEmpty((String)endpointName)) {
            sql.append(" and ").append("endpoint_name").append(" like concat('%',?,'%')");
            parameters.add(endpointName);
        }
        if (Objects.nonNull(relatedTrace)) {
            if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                sql.append(" and ").append("trace_id").append(" = ?");
                parameters.add(relatedTrace.getTraceId());
            }
            if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                sql.append(" and ").append("trace_segment_id").append(" = ?");
                parameters.add(relatedTrace.getSegmentId());
            }
            if (Objects.nonNull(relatedTrace.getSpanId())) {
                sql.append(" and ").append("span_id").append(" = ?");
                parameters.add(relatedTrace.getSpanId());
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (Tag tag : tags) {
                int foundIdx = this.searchableTagKeys.indexOf(tag.getKey());
                if (foundIdx > -1) {
                    sql.append(" and (");
                    for (int i = 0; i < this.numOfSearchValuesPerTag; ++i) {
                        String physicalColumn = "tags_" + (foundIdx * this.numOfSearchValuesPerTag + i);
                        sql.append(physicalColumn).append(" = ? ");
                        parameters.add(tag.toString());
                        if (i == this.numOfSearchValuesPerTag - 1) continue;
                        sql.append(" or ");
                    }
                    sql.append(")");
                    continue;
                }
                return new Logs();
            }
        }
        sql.append(" order by ").append("timestamp").append(" ").append(Order.DES.equals((Object)queryOrder) ? SortOrder.DESC : SortOrder.ASC);
        Logs logs = new Logs();
        try (Connection connection = this.h2Client.getConnection();){
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, this.buildCountStatement(sql.toString()), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    logs.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.h2Client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));
            var22_25 = null;
            try {
                while (resultSet.next()) {
                    Log log = new Log();
                    log.setServiceId(resultSet.getString("service_id"));
                    log.setServiceInstanceId(resultSet.getString("service_instance_id"));
                    log.setEndpointId(resultSet.getString("endpoint_id"));
                    log.setEndpointName(resultSet.getString("endpoint_name"));
                    log.setTraceId(resultSet.getString("trace_id"));
                    log.setTimestamp(Long.valueOf(resultSet.getLong("timestamp")));
                    log.setContentType(ContentType.instanceOf((int)resultSet.getInt("content_type")));
                    log.setContent(resultSet.getString("content"));
                    String dataBinaryBase64 = resultSet.getString("tags_raw_data");
                    if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                        this.parserDataBinary(dataBinaryBase64, log.getTags());
                    }
                    logs.getLogs().add(log);
                }
            }
            catch (Throwable throwable) {
                var22_25 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var22_25 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var22_25.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return logs;
    }

    protected String buildCountStatement(String sql) {
        return "select count(1) total from (select 1 " + sql + " )";
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }
}

