/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2BrowserLogQueryDAO
implements IBrowserLogQueryDAO {
    private final JDBCHikariCPClient h2Client;

    public BrowserErrorLogs queryBrowserErrorLogs(String serviceId, String serviceVersionId, String pagePathId, String pagePath, BrowserErrorCategory category, long startSecondTB, long endSecondTB, int limit, int from) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(9);
        sql.append("from ").append("browser_error_log").append(" where ").append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceVersionId)) {
            sql.append(" and ").append("service_version_id").append(" = ?");
            parameters.add(serviceVersionId);
        }
        if (StringUtil.isNotEmpty((String)pagePathId)) {
            sql.append(" and ").append("pate_path_id").append(" = ?");
            parameters.add(pagePathId);
        }
        if (Objects.nonNull(category)) {
            sql.append(" and ").append("error_category").append(" = ?");
            parameters.add(category.getValue());
        }
        if (!Strings.isNullOrEmpty((String)pagePath)) {
            sql.append(" and ").append("page_path").append(" like concat('%',?,'%')");
            parameters.add(pagePath);
        }
        BrowserErrorLogs logs = new BrowserErrorLogs();
        try (Connection connection = this.h2Client.getConnection();){
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, this.buildCountStatement(sql.toString()), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    logs.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.h2Client.executeQuery(connection, "select data_binary " + sql.toString(), parameters.toArray(new Object[0]));
            var18_19 = null;
            try {
                while (resultSet.next()) {
                    String dataBinaryBase64 = resultSet.getString("data_binary");
                    if (!Objects.nonNull(dataBinaryBase64)) continue;
                    BrowserErrorLog log = this.parserDataBinary(dataBinaryBase64);
                    logs.getLogs().add(log);
                }
            }
            catch (Throwable throwable) {
                var18_19 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var18_19 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var18_19.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return logs;
    }

    protected String buildCountStatement(String sql) {
        return "select count(1) total from (select 1 " + sql + " )";
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" limit ").append(limit);
        sql.append(" offset ").append(from);
    }

    @Generated
    public H2BrowserLogQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }
}

