/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.AbstractSearchTagBuilder;

public class H2AlarmRecordBuilder
extends AbstractSearchTagBuilder<Record> {
    public H2AlarmRecordBuilder(int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag, List<String> searchTagKeys) {
        super(maxSizeOfArrayColumn, numOfSearchableValuesPerTag, searchTagKeys, "tags");
    }

    public Record storage2Entity(Map<String, Object> dbMap) {
        AlarmRecord record = new AlarmRecord();
        record.setScope(((Number)dbMap.get("scope")).intValue());
        record.setName((String)dbMap.get("name"));
        record.setId0((String)dbMap.get("id0"));
        record.setId1((String)dbMap.get("id1"));
        record.setAlarmMessage((String)dbMap.get("alarm_message"));
        record.setStartTime(((Number)dbMap.get("start_time")).longValue());
        record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
        record.setRuleName((String)dbMap.get("rule_name"));
        if (StringUtil.isEmpty((String)((String)dbMap.get("tags_raw_data")))) {
            record.setTagsRawData(new byte[0]);
        } else {
            record.setTagsRawData(Base64.getDecoder().decode((String)dbMap.get("tags_raw_data")));
        }
        return record;
    }

    public Map<String, Object> entity2Storage(Record record) {
        AlarmRecord storageData = (AlarmRecord)record;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scope", storageData.getScope());
        map.put("name", storageData.getName());
        map.put("id0", storageData.getId0());
        map.put("id1", storageData.getId1());
        map.put("alarm_message", storageData.getAlarmMessage());
        map.put("start_time", storageData.getStartTime());
        map.put("time_bucket", storageData.getTimeBucket());
        map.put("rule_name", storageData.getRuleName());
        if (CollectionUtils.isEmpty((byte[])storageData.getTagsRawData())) {
            map.put("tags_raw_data", "");
        } else {
            map.put("tags_raw_data", new String(Base64.getEncoder().encode(storageData.getTagsRawData())));
        }
        this.analysisSearchTag(storageData.getTags(), map);
        return map;
    }
}

