/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class H2AlarmQueryDAO
implements IAlarmQueryDAO {
    private JDBCHikariCPClient client;
    private final ModuleManager manager;
    private final int maxSizeOfArrayColumn;
    private final int numOfSearchValuesPerTag;
    private List<String> searchableTagKeys;

    public H2AlarmQueryDAO(JDBCHikariCPClient client, ModuleManager manager, int maxSizeOfArrayColumn, int numOfSearchValuesPerTag) {
        this.client = client;
        this.manager = manager;
        this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
        this.numOfSearchValuesPerTag = numOfSearchValuesPerTag;
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB, List<Tag> tags) throws IOException {
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableAlarmTags().split(","));
            if (this.searchableTagKeys.size() > this.maxSizeOfArrayColumn) {
                this.searchableTagKeys = this.searchableTagKeys.subList(0, this.maxSizeOfArrayColumn);
            }
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("alarm_record").append(" where ");
        sql.append(" 1=1 ");
        if (Objects.nonNull(scopeId)) {
            sql.append(" and ").append("scope").append(" = ?");
            parameters.add(scopeId);
        }
        if (startTB != 0L && endTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endTB);
        }
        if (!org.elasticsearch.common.Strings.isNullOrEmpty((String)keyword)) {
            sql.append(" and ").append("alarm_message").append(" like concat('%',?,'%') ");
            parameters.add(keyword);
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (Tag tag : tags) {
                int foundIdx = this.searchableTagKeys.indexOf(tag.getKey());
                if (foundIdx > -1) {
                    sql.append(" and (");
                    for (int i = 0; i < this.numOfSearchValuesPerTag; ++i) {
                        String physicalColumn = "tags_" + (foundIdx * this.numOfSearchValuesPerTag + i);
                        sql.append(physicalColumn).append(" = ? ");
                        parameters.add(tag.toString());
                        if (i == this.numOfSearchValuesPerTag - 1) continue;
                        sql.append(" or ");
                    }
                    sql.append(")");
                    continue;
                }
                return new Alarms();
            }
        }
        sql.append(" order by ").append("start_time").append(" desc ");
        Alarms alarms = new Alarms();
        try (Connection connection = this.client.getConnection();){
            try (ResultSet resultSet = this.client.executeQuery(connection, this.buildCountStatement(sql.toString()), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    alarms.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));
            var16_19 = null;
            try {
                while (resultSet.next()) {
                    AlarmMessage message = new AlarmMessage();
                    message.setId(resultSet.getString("id0"));
                    message.setId1(resultSet.getString("id1"));
                    message.setMessage(resultSet.getString("alarm_message"));
                    message.setStartTime(Long.valueOf(resultSet.getLong("start_time")));
                    message.setScope(Scope.Finder.valueOf((int)resultSet.getInt("scope")));
                    message.setScopeId(resultSet.getInt("scope"));
                    String dataBinaryBase64 = resultSet.getString("tags_raw_data");
                    if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                        this.parserDataBinaryBase64(dataBinaryBase64, message.getTags());
                    }
                    alarms.getMsgs().add(message);
                }
            }
            catch (Throwable throwable) {
                var16_19 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var16_19 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var16_19.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return alarms;
    }

    protected String buildCountStatement(String sql) {
        return "select count(1) total from (select 1 " + sql + " )";
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }
}

