/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2AggregationQueryDAO
implements IAggregationQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2AggregationQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<SelectedRecord> sortMetrics(TopNCondition metrics, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) throws IOException {
        ArrayList<Long> conditions = new ArrayList<Long>(10);
        StringBuilder sql = this.buildMetricsValueSql(valueColumnName, metrics.getName());
        sql.append("time_bucket").append(" >= ? and ").append("time_bucket").append(" <= ?");
        conditions.add(duration.getStartTimeBucket());
        conditions.add(duration.getEndTimeBucket());
        if (additionalConditions != null) {
            additionalConditions.forEach(condition -> {
                sql.append(" and ").append(condition.getKey()).append("=?");
                conditions.add((Long)((Object)condition.getValue()));
            });
        }
        sql.append(" group by ").append("entity_id");
        sql.append(")  as T order by value ").append(metrics.getOrder().equals((Object)Order.ASC) ? "asc" : "desc").append(" limit ").append(metrics.getTopN());
        ArrayList<SelectedRecord> topNEntities = new ArrayList<SelectedRecord>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), conditions.toArray(new Object[0]));){
            while (resultSet.next()) {
                SelectedRecord topNEntity = new SelectedRecord();
                topNEntity.setId(resultSet.getString("entity_id"));
                topNEntity.setValue(resultSet.getString("value"));
                topNEntities.add(topNEntity);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return topNEntities;
    }

    protected StringBuilder buildMetricsValueSql(String valueColumnName, String metricsName) {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from (select avg(").append(valueColumnName).append(") value,").append("entity_id").append(" from ").append(metricsName).append(" where ");
        return sql;
    }

    @Generated
    protected JDBCHikariCPClient getH2Client() {
        return this.h2Client;
    }
}

