/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.StorageHashMapBuilder;

public abstract class AbstractSearchTagBuilder<T extends Record>
implements StorageHashMapBuilder<T> {
    private final int numOfSearchableValuesPerTag;
    private final List<String> searchTagKeys;
    private final String tagColumn;

    public AbstractSearchTagBuilder(int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag, List<String> searchTagKeys, String tagColumn) {
        this.numOfSearchableValuesPerTag = numOfSearchableValuesPerTag;
        int maxNumOfTags = maxSizeOfArrayColumn / numOfSearchableValuesPerTag;
        this.searchTagKeys = searchTagKeys.size() > maxNumOfTags ? searchTagKeys.subList(0, maxNumOfTags) : searchTagKeys;
        this.tagColumn = tagColumn;
    }

    protected void analysisSearchTag(List<Tag> rawTags, Map<String, Object> dbMap) {
        rawTags.forEach(tag -> {
            int index = this.searchTagKeys.indexOf(tag.getKey());
            boolean shouldAdd = true;
            int tagInx = 0;
            String tagExpression = tag.toString();
            for (int i = 0; i < this.numOfSearchableValuesPerTag; ++i) {
                tagInx = index * this.numOfSearchableValuesPerTag + i;
                String previousValue = (String)dbMap.get(this.tagColumn + "_" + tagInx);
                if (previousValue == null) {
                    shouldAdd = true;
                    break;
                }
                if (previousValue.equals(tagExpression)) {
                    shouldAdd = false;
                    break;
                }
                if (i != this.numOfSearchableValuesPerTag - 1) continue;
                shouldAdd = false;
            }
            if (shouldAdd) {
                dbMap.put(this.tagColumn + "_" + tagInx, tagExpression);
            }
        });
    }
}

