/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2;

import java.util.Properties;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.H2StorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2AggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2AlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2BrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2EventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2LogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2StorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TraceQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2UITemplateManagementDAO;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2StorageProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2StorageProvider.class);
    private H2StorageConfig config = new H2StorageConfig();
    private JDBCHikariCPClient h2Client;

    public String name() {
        return "h2";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        Properties settings = new Properties();
        settings.setProperty("dataSourceClassName", this.config.getDriver());
        settings.setProperty("dataSource.url", this.config.getUrl());
        settings.setProperty("dataSource.user", this.config.getUser());
        settings.setProperty("dataSource.password", this.config.getPassword());
        this.h2Client = new JDBCHikariCPClient(settings);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new H2BatchDAO(this.h2Client));
        this.registerServiceImplementation(StorageDAO.class, (Service)new H2StorageDAO(this.getManager(), this.h2Client, this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new H2NetworkAddressAliasDAO(this.h2Client));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new H2TopologyQueryDAO(this.h2Client));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new H2MetricsQueryDAO(this.h2Client));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new H2TraceQueryDAO(this.getManager(), this.h2Client, this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new H2BrowserLogQueryDAO(this.h2Client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new H2MetadataQueryDAO(this.h2Client, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new H2AggregationQueryDAO(this.h2Client));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new H2AlarmQueryDAO(this.h2Client, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new H2HistoryDeleteDAO(this.h2Client));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new H2TopNRecordsQueryDAO(this.h2Client));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new H2LogQueryDAO(this.h2Client, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new H2ProfileTaskQueryDAO(this.h2Client));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new H2ProfileTaskLogQueryDAO(this.h2Client));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new H2ProfileThreadSnapshotQueryDAO(this.h2Client));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new H2UITemplateManagementDAO(this.h2Client));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new H2EventQueryDAO(this.h2Client));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ConfigService configService = (ConfigService)this.getManager().find("core").provider().getService(ConfigService.class);
        int numOfSearchableTracesTags = configService.getSearchableTracesTags().split(",").length;
        if (numOfSearchableTracesTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableTracesTags[" + numOfSearchableTracesTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        int numOfSearchableLogsTags = configService.getSearchableLogsTags().split(",").length;
        if (numOfSearchableLogsTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableLogsTags[" + numOfSearchableLogsTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_h2", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.h2Client.registerChecker((HealthChecker)healthChecker);
        try {
            this.h2Client.connect();
            H2TableInstaller installer = new H2TableInstaller((Client)this.h2Client, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag());
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)installer);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

