/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLExecutor
implements InsertRequest,
UpdateRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLExecutor.class);
    private String sql;
    private List<Object> param;

    public SQLExecutor(String sql, List<Object> param) {
        this.sql = sql;
        this.param = param;
    }

    public void invoke(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
        for (int i = 0; i < this.param.size(); ++i) {
            preparedStatement.setObject(i + 1, this.param.get(i));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("execute sql in batch: {}, parameters: {}", (Object)this.sql, this.param);
        }
        preparedStatement.execute();
    }
}

