/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.common.timer.TimerTaskList;

class TimingWheel {
    private final Long tickMs;
    private final Integer wheelSize;
    private final AtomicInteger taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final Long interval;
    private final TimerTaskList[] buckets;
    private Long currentTime;
    private TimingWheel overflowWheel;

    TimingWheel(Long tickMs, Integer wheelSize, Long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize.intValue();
        this.currentTime = startMs - startMs % tickMs;
        this.buckets = new TimerTaskList[wheelSize.intValue()];
    }

    private synchronized void addOverflowWheel() {
        if (this.overflowWheel == null) {
            this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.taskCounter, this.queue);
        }
    }

    boolean add(TimerTaskList.TimerTaskEntry taskEntry) {
        Long expirationMs = taskEntry.getExpirationMs();
        if (taskEntry.cancelled()) {
            return false;
        }
        if (expirationMs < this.currentTime + this.tickMs) {
            return false;
        }
        if (expirationMs < this.currentTime + this.interval) {
            long virtualId = expirationMs / this.tickMs;
            int index = (int)(virtualId % (long)this.wheelSize.intValue());
            TimerTaskList bucket = this.getBucket(index);
            bucket.add(taskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(taskEntry);
    }

    void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
        }
        if (this.overflowWheel != null) {
            this.overflowWheel.advanceClock(this.currentTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTaskList getBucket(int index) {
        TimerTaskList bucket = this.buckets[index];
        if (bucket == null) {
            TimingWheel timingWheel = this;
            synchronized (timingWheel) {
                bucket = this.buckets[index];
                if (bucket == null) {
                    this.buckets[index] = bucket = new TimerTaskList(this.taskCounter);
                }
            }
        }
        return bucket;
    }
}

