/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.alert.strategy;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.apache.shenyu.alert.AlertNotifyHandler;
import org.apache.shenyu.common.dto.AlarmContent;
import org.springframework.web.client.RestTemplate;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

abstract class AbstractAlertNotifyHandler
implements AlertNotifyHandler {
    protected static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Resource
    private TemplateEngine templateEngine;
    @Resource
    private RestTemplate restTemplate;

    AbstractAlertNotifyHandler() {
    }

    protected String renderContent(AlarmContent alert) {
        Context context = new Context();
        context.setVariable("title", (Object)"[ShenYu Alarm]");
        context.setVariable("titleLabel", (Object)"Alarm Title");
        context.setVariable("alarmTitle", (Object)alert.getTitle());
        context.setVariable("triggerTimeLabel", (Object)"Alarm Time");
        context.setVariable("triggerTime", (Object)DTF.format(LocalDateTime.ofInstant(alert.getDateCreated() == null ? Instant.now() : alert.getDateCreated().toInstant(), TimeZone.getDefault().toZoneId())));
        context.setVariable("contentLabel", (Object)"Alarm Content");
        context.setVariable("content", (Object)alert.getContent());
        return AbstractAlertNotifyHandler.removeBlankLine(this.templateEngine.process(this.templateName(), (IContext)context));
    }

    protected abstract String templateName();

    private static String removeBlankLine(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("(?m)^\\s*$(\\n|\\r\\n)", "");
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

