/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.version;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.infra.autogen.version.ShardingSphereVersion;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.database.DatabaseServerInfo;
import org.apache.shardingsphere.proxy.frontend.protocol.DatabaseProtocolFrontendEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereProxyVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereProxyVersion.class);

    public static void setVersion(ContextManager contextManager) {
        CommonConstants.PROXY_VERSION.set(ShardingSphereProxyVersion.getProxyVersion());
        contextManager.getMetaDataContexts().getMetaData().getDatabases().keySet().forEach(each -> ShardingSphereProxyVersion.setDatabaseVersion(each, contextManager.getDataSourceMap(each)));
    }

    private static String getProxyVersion() {
        String result = "5.1.2";
        if (!ShardingSphereVersion.IS_SNAPSHOT || Strings.isNullOrEmpty((String)ShardingSphereVersion.BUILD_GIT_COMMIT_ID_ABBREV)) {
            return result;
        }
        result = result + (ShardingSphereVersion.BUILD_GIT_DIRTY ? "-dirty" : "");
        result = result + "-" + ShardingSphereVersion.BUILD_GIT_COMMIT_ID_ABBREV;
        return result;
    }

    private static void setDatabaseVersion(String databaseName, Map<String, DataSource> dataSources) {
        Optional<DataSource> dataSource = dataSources.values().stream().findFirst();
        if (!dataSource.isPresent()) {
            return;
        }
        DatabaseServerInfo databaseServerInfo = new DatabaseServerInfo(dataSource.get());
        log.info("{}, database name is `{}`", (Object)databaseServerInfo, (Object)databaseName);
        DatabaseProtocolFrontendEngineFactory.newInstance((DatabaseType)DatabaseTypeEngine.getTrunkDatabaseType((String)databaseServerInfo.getDatabaseName())).setDatabaseVersion(databaseName, databaseServerInfo.getDatabaseVersion());
    }
}

