/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.initializer;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.ModeConfigurationYamlSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderFactory;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListener;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListenerFactory;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.version.ShardingSphereProxyVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BootstrapInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapInitializer.class);

    public void init(YamlProxyConfiguration yamlConfig, int port) throws SQLException {
        ModeConfiguration modeConfig = null == yamlConfig.getServerConfiguration().getMode() ? null : new ModeConfigurationYamlSwapper().swapToObject(yamlConfig.getServerConfiguration().getMode());
        ContextManager contextManager = this.createContextManager(yamlConfig, modeConfig, port);
        ProxyContext.init((ContextManager)contextManager);
        this.contextManagerInitializedCallback(modeConfig, contextManager);
        ShardingSphereProxyVersion.setVersion(contextManager);
    }

    private ContextManager createContextManager(YamlProxyConfiguration yamlConfig, ModeConfiguration modeConfig, int port) throws SQLException {
        ProxyConfiguration proxyConfig = new YamlProxyConfigurationSwapper().swap(yamlConfig);
        ContextManagerBuilderParameter parameter = ContextManagerBuilderParameter.builder().modeConfig(modeConfig).databaseConfigs(proxyConfig.getDatabaseConfigurations()).globalRuleConfigs(proxyConfig.getGlobalConfiguration().getRules()).props(proxyConfig.getGlobalConfiguration().getProperties()).labels(proxyConfig.getGlobalConfiguration().getLabels()).instanceDefinition(new InstanceDefinition(InstanceType.PROXY, Integer.valueOf(port))).build();
        return ContextManagerBuilderFactory.getInstance((ModeConfiguration)modeConfig).build(parameter);
    }

    private void contextManagerInitializedCallback(ModeConfiguration modeConfig, ContextManager contextManager) {
        for (ContextManagerLifecycleListener each : ContextManagerLifecycleListenerFactory.getAllInstances()) {
            try {
                each.onInitialized(modeConfig, contextManager);
            }
            catch (Exception ex) {
                log.error("contextManager onInitialized callback for '{}' failed", (Object)each.getClass().getName(), (Object)ex);
            }
        }
    }

    @Generated
    public BootstrapInitializer() {
    }
}

