/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.arguments;

import java.util.Optional;
import lombok.Generated;

public final class BootstrapArguments {
    private static final String DEFAULT_CONFIG_PATH = "/conf/";
    private final String[] args;

    public Optional<Integer> getPort() {
        if (0 == this.args.length) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(this.args[0]));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Invalid port `%s`.", this.args[0]));
        }
    }

    public String getConfigurationPath() {
        return this.args.length < 2 ? DEFAULT_CONFIG_PATH : this.paddingWithSlash(this.args[1]);
    }

    private String paddingWithSlash(String pathArg) {
        StringBuilder result = new StringBuilder(pathArg);
        if (!pathArg.startsWith("/")) {
            result.insert(0, '/');
        }
        if (!pathArg.endsWith("/")) {
            result.append('/');
        }
        return result.toString();
    }

    @Generated
    public BootstrapArguments(String[] args) {
        this.args = args;
    }
}

