/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.session.transaction;

import lombok.Generated;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.exception.SwitchTypeInTransactionException;

public final class TransactionStatus {
    private volatile boolean inTransaction;
    private volatile TransactionType transactionType;
    private volatile boolean rollbackOnly;

    public TransactionStatus(TransactionType initialTransactionType) {
        this.transactionType = initialTransactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        if (this.inTransaction) {
            throw new SwitchTypeInTransactionException();
        }
        this.transactionType = transactionType;
    }

    public boolean isInConnectionHeldTransaction() {
        return this.inTransaction && TransactionType.BASE != this.transactionType;
    }

    @Generated
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Generated
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Generated
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Generated
    public void setInTransaction(boolean inTransaction) {
        this.inTransaction = inTransaction;
    }

    @Generated
    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }
}

