/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;

public final class RequiredSessionVariableRecorder {
    private static final String DEFAULT = "DEFAULT";
    private final Map<String, String> sessionVariables = new ConcurrentHashMap<String, String>();

    public void setVariable(String variableName, String variableValue) {
        this.sessionVariables.put(variableName, variableValue);
    }

    public boolean isEmpty() {
        return this.sessionVariables.isEmpty();
    }

    public List<String> toSetSQLs(String databaseType) {
        if (this.sessionVariables.isEmpty()) {
            return Collections.emptyList();
        }
        switch (databaseType) {
            case "MySQL": {
                return Collections.singletonList(this.aggregateToMySQLSetSQL());
            }
            case "PostgreSQL": {
                return this.convertToPostgreSQLSetSQLs();
            }
        }
        return Collections.emptyList();
    }

    private String aggregateToMySQLSetSQL() {
        StringJoiner result = new StringJoiner(",", "SET ", "");
        for (Map.Entry<String, String> stringStringEntry : this.sessionVariables.entrySet()) {
            String s = stringStringEntry.getKey() + "=" + stringStringEntry.getValue();
            result.add(s);
        }
        return result.toString();
    }

    private List<String> convertToPostgreSQLSetSQLs() {
        ArrayList<String> result = new ArrayList<String>(this.sessionVariables.size());
        for (Map.Entry<String, String> entry : this.sessionVariables.entrySet()) {
            result.add("SET " + entry.getKey() + "=" + entry.getValue());
        }
        return result;
    }

    public List<String> toResetSQLs(String databaseType) {
        if (this.sessionVariables.isEmpty()) {
            return Collections.emptyList();
        }
        switch (databaseType) {
            case "MySQL": {
                return Collections.singletonList(this.aggregateToMySQLSetDefaultSQLs());
            }
            case "PostgreSQL": {
                return Collections.singletonList("RESET ALL");
            }
        }
        return Collections.emptyList();
    }

    private String aggregateToMySQLSetDefaultSQLs() {
        StringJoiner result = new StringJoiner(",", "SET ", "");
        for (String each : this.sessionVariables.keySet()) {
            result.add(each + "=" + DEFAULT);
        }
        return result.toString();
    }

    public void removeVariablesWithDefaultValue() {
        this.sessionVariables.entrySet().removeIf(entry -> DEFAULT.equalsIgnoreCase((String)entry.getValue()));
    }
}

