/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.session;

import io.netty.util.AttributeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.CacheableExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.PreparedStatementRegistry;
import org.apache.shardingsphere.proxy.backend.session.RequiredSessionVariableRecorder;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.sql.parser.sql.common.constant.TransactionIsolationLevel;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ConnectionSession {
    private final DatabaseType databaseType;
    private volatile String databaseName;
    private volatile int connectionId;
    private volatile Grantee grantee;
    private final TransactionStatus transactionStatus;
    private final AttributeMap attributeMap;
    private volatile boolean autoCommit = true;
    private volatile boolean readOnly;
    private TransactionIsolationLevel defaultIsolationLevel;
    private TransactionIsolationLevel isolationLevel;
    private final BackendConnection backendConnection;
    private final ExecutorStatementManager statementManager;
    private final PreparedStatementRegistry preparedStatementRegistry = new PreparedStatementRegistry();
    private final ConnectionContext connectionContext;
    private final RequiredSessionVariableRecorder requiredSessionVariableRecorder = new RequiredSessionVariableRecorder();
    private volatile String executionId;
    private QueryContext queryContext;

    public ConnectionSession(DatabaseType databaseType, TransactionType initialTransactionType, AttributeMap attributeMap) {
        this.databaseType = databaseType;
        this.transactionStatus = new TransactionStatus(initialTransactionType);
        this.attributeMap = attributeMap;
        this.backendConnection = this.determineBackendConnection();
        this.statementManager = this.determineStatementManager();
        this.connectionContext = this.backendConnection instanceof CacheableExecutorConnectionManager ? new ConnectionContext(() -> ((CacheableExecutorConnectionManager)((CacheableExecutorConnectionManager)this.backendConnection)).getDataSourceNamesOfCachedConnections()) : new ConnectionContext();
    }

    private BackendConnection determineBackendConnection() {
        String proxyBackendDriverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        return "ExperimentalVertx".equals(proxyBackendDriverType) ? new VertxBackendConnection(this) : new JDBCBackendConnection(this);
    }

    private ExecutorStatementManager determineStatementManager() {
        String proxyBackendDriverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        return "ExperimentalVertx".equals(proxyBackendDriverType) ? new VertxBackendStatement() : new JDBCBackendStatement();
    }

    public void setCurrentDatabase(String databaseName) {
        if (null == databaseName || !databaseName.equals(this.databaseName)) {
            this.databaseName = databaseName;
        }
    }

    public String getDatabaseName() {
        return null == this.queryContext ? this.databaseName : this.queryContext.findSqlStatementDatabaseName().orElse(this.databaseName);
    }

    public String getDefaultDatabaseName() {
        return this.databaseName;
    }

    public void clearQueryContext() {
        this.queryContext = null;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public int getConnectionId() {
        return this.connectionId;
    }

    @Generated
    public Grantee getGrantee() {
        return this.grantee;
    }

    @Generated
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Generated
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Generated
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public TransactionIsolationLevel getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    @Generated
    public TransactionIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Generated
    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }

    @Generated
    public ExecutorStatementManager getStatementManager() {
        return this.statementManager;
    }

    @Generated
    public PreparedStatementRegistry getPreparedStatementRegistry() {
        return this.preparedStatementRegistry;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Generated
    public RequiredSessionVariableRecorder getRequiredSessionVariableRecorder() {
        return this.requiredSessionVariableRecorder;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Generated
    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    @Generated
    public void setGrantee(Grantee grantee) {
        this.grantee = grantee;
    }

    @Generated
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public void setDefaultIsolationLevel(TransactionIsolationLevel defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    @Generated
    public void setIsolationLevel(TransactionIsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    @Generated
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setQueryContext(QueryContext queryContext) {
        this.queryContext = queryContext;
    }
}

