/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class UpdateResponseHeader
implements ResponseHeader {
    private final SQLStatement sqlStatement;
    private final long lastInsertId;
    private final Collection<Integer> updateCounts = new LinkedList<Integer>();
    private long updateCount;

    public UpdateResponseHeader(SQLStatement sqlStatement) {
        this(sqlStatement, Collections.emptyList());
    }

    public UpdateResponseHeader(SQLStatement sqlStatement, Collection<UpdateResult> updateResults) {
        this.sqlStatement = sqlStatement;
        this.lastInsertId = this.getLastInsertId(updateResults);
        this.updateCount = updateResults.iterator().hasNext() ? (long)updateResults.iterator().next().getUpdateCount() : 0L;
        for (UpdateResult each : updateResults) {
            this.updateCounts.add(each.getUpdateCount());
        }
    }

    private long getLastInsertId(Collection<UpdateResult> updateResults) {
        long result = 0L;
        for (UpdateResult each : updateResults) {
            result = Math.max(result, each.getLastInsertId());
        }
        return result;
    }

    public void mergeUpdateCount() {
        this.updateCount = 0L;
        for (int each : this.updateCounts) {
            this.updateCount += (long)each;
        }
    }

    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Generated
    public long getUpdateCount() {
        return this.updateCount;
    }
}

