/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.query.impl;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilder;

public final class MySQLQueryHeaderBuilder
implements QueryHeaderBuilder {
    @Override
    public QueryHeader build(QueryResultMetaData queryResultMetaData, ShardingSphereDatabase database, String columnName, String columnLabel, int columnIndex) throws SQLException {
        boolean primaryKey;
        String tableName;
        String schemaName = null == database ? "" : database.getName();
        String actualTableName = queryResultMetaData.getTableName(columnIndex);
        if (null == actualTableName || null == database) {
            tableName = actualTableName;
            primaryKey = false;
        } else {
            tableName = this.getLogicTableName(database, actualTableName);
            ShardingSphereSchema schema = database.getSchema(schemaName);
            primaryKey = null != schema && Optional.ofNullable(schema.getTable(tableName)).map(optional -> (ShardingSphereColumn)optional.getColumns().get(columnName.toLowerCase())).map(ShardingSphereColumn::isPrimaryKey).orElse(false) != false;
        }
        int columnType = queryResultMetaData.getColumnType(columnIndex);
        String columnTypeName = queryResultMetaData.getColumnTypeName(columnIndex);
        int columnLength = queryResultMetaData.getColumnLength(columnIndex);
        int decimals = queryResultMetaData.getDecimals(columnIndex);
        boolean signed = queryResultMetaData.isSigned(columnIndex);
        boolean notNull = queryResultMetaData.isNotNull(columnIndex);
        boolean autoIncrement = queryResultMetaData.isAutoIncrement(columnIndex);
        return new QueryHeader(schemaName, tableName, columnLabel, columnName, columnType, columnTypeName, columnLength, decimals, signed, primaryKey, notNull, autoIncrement);
    }

    private String getLogicTableName(ShardingSphereDatabase database, String actualTableName) {
        for (DataNodeContainedRule each : database.getRuleMetaData().findRules(DataNodeContainedRule.class)) {
            Optional logicTable = each.findLogicTableByActualTable(actualTableName);
            if (!logicTable.isPresent()) continue;
            return (String)logicTable.get();
        }
        return actualTableName;
    }

    public String getType() {
        return "MySQL";
    }

    public boolean isDefault() {
        return true;
    }
}

