/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.query;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderFactory;

public final class QueryHeaderBuilderEngine {
    private final DatabaseType databaseType;

    public QueryHeader build(QueryResultMetaData queryResultMetaData, ShardingSphereDatabase database, int columnIndex) throws SQLException {
        String columnName = queryResultMetaData.getColumnName(columnIndex);
        String columnLabel = queryResultMetaData.getColumnLabel(columnIndex);
        return QueryHeaderBuilderFactory.getInstance(this.databaseType).build(queryResultMetaData, database, columnName, columnLabel, columnIndex);
    }

    public QueryHeader build(ProjectionsContext projectionsContext, QueryResultMetaData queryResultMetaData, ShardingSphereDatabase database, int columnIndex) throws SQLException {
        String columnName = this.getColumnName(projectionsContext, queryResultMetaData, columnIndex);
        String columnLabel = this.getColumnLabel(projectionsContext, queryResultMetaData, columnIndex);
        return QueryHeaderBuilderFactory.getInstance(this.databaseType).build(queryResultMetaData, database, columnName, columnLabel, columnIndex);
    }

    private String getColumnLabel(ProjectionsContext projectionsContext, QueryResultMetaData queryResultMetaData, int columnIndex) throws SQLException {
        Projection projection = (Projection)projectionsContext.getExpandProjections().get(columnIndex - 1);
        return DerivedColumn.isDerivedColumnName((String)projection.getColumnLabel()) ? projection.getExpression() : queryResultMetaData.getColumnLabel(columnIndex);
    }

    private String getColumnName(ProjectionsContext projectionsContext, QueryResultMetaData queryResultMetaData, int columnIndex) throws SQLException {
        Projection projection = (Projection)projectionsContext.getExpandProjections().get(columnIndex - 1);
        return projection instanceof ColumnProjection ? ((ColumnProjection)projection).getName() : queryResultMetaData.getColumnName(columnIndex);
    }

    @Generated
    public QueryHeaderBuilderEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

