/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.transaction;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.XAStatement;
import org.apache.shardingsphere.transaction.xa.jta.exception.XATransactionNestedBeginException;

public final class TransactionXAHandler
implements ProxyBackendHandler {
    private final XAStatement tclStatement;
    private final ConnectionSession connectionSession;
    private final JDBCDatabaseCommunicationEngine backendHandler;

    public TransactionXAHandler(SQLStatementContext<? extends TCLStatement> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        this.tclStatement = (XAStatement)sqlStatementContext.getSqlStatement();
        this.connectionSession = connectionSession;
        QueryContext queryContext = new QueryContext(sqlStatementContext, sql, Collections.emptyList());
        this.backendHandler = (JDBCDatabaseCommunicationEngine)DatabaseCommunicationEngineFactory.getInstance().newDatabaseCommunicationEngine(queryContext, connectionSession.getBackendConnection(), false);
    }

    @Override
    public boolean next() throws SQLException {
        return this.tclStatement.getOp().equals("RECOVER") && this.backendHandler.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        return this.tclStatement.getOp().equals("RECOVER") ? this.backendHandler.getRowData() : new QueryResponseRow(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        switch (this.tclStatement.getOp()) {
            case "START": 
            case "BEGIN": {
                ShardingSpherePreconditions.checkState((!this.connectionSession.getTransactionStatus().isInTransaction() ? 1 : 0) != 0, XATransactionNestedBeginException::new);
                ResponseHeader header = this.backendHandler.execute();
                this.connectionSession.getConnectionContext().getTransactionConnectionContext().setInTransaction(true);
                return header;
            }
            case "END": 
            case "PREPARE": 
            case "RECOVER": {
                return this.backendHandler.execute();
            }
            case "COMMIT": 
            case "ROLLBACK": {
                try {
                    ResponseHeader responseHeader = this.backendHandler.execute();
                    return responseHeader;
                }
                finally {
                    this.connectionSession.getConnectionContext().clearTransactionConnectionContext();
                    this.connectionSession.getConnectionContext().clearCursorConnectionContext();
                }
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("unrecognized XA statement `%s`", this.tclStatement.getOp()));
    }

    @Generated
    public TransactionXAHandler(XAStatement tclStatement, ConnectionSession connectionSession, JDBCDatabaseCommunicationEngine backendHandler) {
        this.tclStatement = tclStatement;
        this.connectionSession = connectionSession;
        this.backendHandler = backendHandler;
    }
}

