/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.transaction;

import lombok.Generated;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtil;
import org.apache.shardingsphere.sql.parser.sql.common.constant.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;
import org.apache.shardingsphere.transaction.exception.SwitchTypeInTransactionException;

public final class TransactionSetHandler
implements ProxyBackendHandler {
    private final SetTransactionStatement sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public ResponseHeader execute() {
        ShardingSpherePreconditions.checkState((null != this.sqlStatement.getScope() || !this.connectionSession.getTransactionStatus().isInTransaction() ? 1 : 0) != 0, SwitchTypeInTransactionException::new);
        if (TransactionAccessType.READ_ONLY == this.sqlStatement.getAccessMode()) {
            this.connectionSession.setReadOnly(true);
        } else if (TransactionAccessType.READ_WRITE == this.sqlStatement.getAccessMode()) {
            this.connectionSession.setReadOnly(false);
        }
        if (null != this.sqlStatement.getIsolationLevel()) {
            this.connectionSession.setDefaultIsolationLevel(this.sqlStatement instanceof MySQLStatement ? TransactionUtil.getTransactionIsolationLevel(4) : TransactionUtil.getTransactionIsolationLevel(2));
            this.connectionSession.setIsolationLevel(this.sqlStatement.getIsolationLevel());
        }
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    @Generated
    public TransactionSetHandler(SetTransactionStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }
}

