/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.transaction;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.shardingsphere.dialect.exception.transaction.InTransactionException;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.communication.TransactionManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.JDBCBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.transaction.VertxLocalTransactionManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.tcl.OpenGaussCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.tcl.OpenGaussRollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLRollbackStatement;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TransactionBackendHandler
implements ProxyBackendHandler {
    private final TCLStatement tclStatement;
    private final TransactionOperationType operationType;
    private final TransactionManager backendTransactionManager;
    private final ConnectionSession connectionSession;

    public TransactionBackendHandler(TCLStatement tclStatement, TransactionOperationType operationType, ConnectionSession connectionSession) {
        this.tclStatement = tclStatement;
        this.operationType = operationType;
        this.connectionSession = connectionSession;
        this.backendTransactionManager = connectionSession.getBackendConnection() instanceof JDBCBackendConnection ? new JDBCBackendTransactionManager((JDBCBackendConnection)connectionSession.getBackendConnection()) : new VertxLocalTransactionManager((VertxBackendConnection)connectionSession.getBackendConnection());
    }

    @Override
    public Future<ResponseHeader> executeFuture() {
        VertxLocalTransactionManager transactionManager = (VertxLocalTransactionManager)this.backendTransactionManager;
        Future<Void> future = this.determineFuture(transactionManager);
        return future.compose(unused -> Future.succeededFuture((Object)new UpdateResponseHeader((SQLStatement)this.tclStatement)));
    }

    private Future<Void> determineFuture(VertxLocalTransactionManager transactionManager) {
        switch (this.operationType) {
            case BEGIN: {
                if (this.connectionSession.getTransactionStatus().isInTransaction()) {
                    if (this.connectionSession.getDatabaseType() instanceof MySQLDatabaseType) {
                        return transactionManager.commit().compose(unused -> transactionManager.begin());
                    }
                    if (this.connectionSession.getDatabaseType() instanceof PostgreSQLDatabaseType || this.connectionSession.getDatabaseType() instanceof OpenGaussDatabaseType) {
                        return Future.failedFuture((Throwable)new InTransactionException());
                    }
                }
                return transactionManager.begin();
            }
            case SAVEPOINT: {
                return transactionManager.setSavepoint(((SavepointStatement)this.tclStatement).getSavepointName());
            }
            case ROLLBACK_TO_SAVEPOINT: {
                return transactionManager.rollbackTo((String)((RollbackStatement)this.tclStatement).getSavepointName().get());
            }
            case RELEASE_SAVEPOINT: {
                return transactionManager.releaseSavepoint(((ReleaseSavepointStatement)this.tclStatement).getSavepointName());
            }
            case COMMIT: {
                return transactionManager.commit();
            }
            case ROLLBACK: {
                return transactionManager.rollback();
            }
        }
        return Future.failedFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        switch (this.operationType) {
            case BEGIN: {
                this.handleBegin();
                break;
            }
            case SAVEPOINT: {
                this.handleSavepoint();
                break;
            }
            case ROLLBACK_TO_SAVEPOINT: {
                this.handleRollbackToSavepoint();
                break;
            }
            case RELEASE_SAVEPOINT: {
                this.handleReleaseSavepoint();
                break;
            }
            case COMMIT: {
                SQLStatement sqlStatement = this.getSQLStatementByCommit();
                this.backendTransactionManager.commit();
                return new UpdateResponseHeader(sqlStatement);
            }
            case ROLLBACK: {
                this.backendTransactionManager.rollback();
                break;
            }
            case SET_AUTOCOMMIT: {
                this.handleSetAutoCommit();
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(this.operationType.name());
            }
        }
        return new UpdateResponseHeader((SQLStatement)this.tclStatement);
    }

    private void handleBegin() throws SQLException {
        if (this.connectionSession.getTransactionStatus().isInTransaction()) {
            if (this.connectionSession.getDatabaseType() instanceof MySQLDatabaseType) {
                this.backendTransactionManager.commit();
            } else if (this.connectionSession.getDatabaseType() instanceof PostgreSQLDatabaseType || this.connectionSession.getDatabaseType() instanceof OpenGaussDatabaseType) {
                throw new InTransactionException();
            }
        }
        this.backendTransactionManager.begin();
    }

    private void handleSavepoint() throws SQLException {
        ShardingSpherePreconditions.checkState((this.connectionSession.getTransactionStatus().isInTransaction() || !this.isPostgreSQLOrOpenGauss() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("SAVEPOINT can only be used in transaction blocks"));
        this.backendTransactionManager.setSavepoint(((SavepointStatement)this.tclStatement).getSavepointName());
    }

    private void handleRollbackToSavepoint() throws SQLException {
        ShardingSpherePreconditions.checkState((this.connectionSession.getTransactionStatus().isInTransaction() || !this.isPostgreSQLOrOpenGauss() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("ROLLBACK TO SAVEPOINT can only be used in transaction blocks"));
        this.backendTransactionManager.rollbackTo((String)((RollbackStatement)this.tclStatement).getSavepointName().get());
    }

    private void handleReleaseSavepoint() throws SQLException {
        ShardingSpherePreconditions.checkState((this.connectionSession.getTransactionStatus().isInTransaction() || !this.isPostgreSQLOrOpenGauss() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("RELEASE SAVEPOINT can only be used in transaction blocks"));
        this.backendTransactionManager.releaseSavepoint(((ReleaseSavepointStatement)this.tclStatement).getSavepointName());
    }

    private boolean isPostgreSQLOrOpenGauss() {
        return this.connectionSession.getDatabaseType() instanceof PostgreSQLDatabaseType || this.connectionSession.getDatabaseType() instanceof OpenGaussDatabaseType;
    }

    private SQLStatement getSQLStatementByCommit() {
        TCLStatement result = this.tclStatement;
        if (this.connectionSession.getTransactionStatus().isRollbackOnly()) {
            if (this.tclStatement instanceof OpenGaussCommitStatement) {
                result = new OpenGaussRollbackStatement();
            } else if (this.tclStatement instanceof PostgreSQLCommitStatement) {
                result = new PostgreSQLRollbackStatement();
            }
        }
        return result;
    }

    private void handleSetAutoCommit() throws SQLException {
        if (this.tclStatement instanceof MySQLSetAutoCommitStatement) {
            this.handleMySQLSetAutoCommit();
        }
        this.connectionSession.setAutoCommit(((SetAutoCommitStatement)this.tclStatement).isAutoCommit());
    }

    private void handleMySQLSetAutoCommit() throws SQLException {
        MySQLSetAutoCommitStatement statement = (MySQLSetAutoCommitStatement)this.tclStatement;
        if (statement.isAutoCommit() && this.connectionSession.getTransactionStatus().isInTransaction()) {
            this.backendTransactionManager.commit();
        }
    }
}

