/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rul.sql;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.distsql.parser.statement.rul.sql.PreviewStatement;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.aware.CursorDefinitionAware;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.decider.engine.SQLFederationDeciderEngine;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.type.CursorAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.SQLRULBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutor;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutorContext;

public final class PreviewHandler
extends SQLRULBackendHandler<PreviewStatement> {
    private static final String DATA_SOURCE_NAME = "data_source_name";
    private static final String ACTUAL_SQL = "actual_sql";
    private final KernelProcessor kernelProcessor = new KernelProcessor();

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(DATA_SOURCE_NAME, ACTUAL_SQL);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) throws SQLException {
        ShardingSphereDatabase database;
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String databaseName = this.getDatabaseName();
        String databaseType = DatabaseTypeEngine.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData().getDatabase(databaseName).getProtocolType());
        ShardingSphereRuleMetaData globalRuleMetaData = metaDataContexts.getMetaData().getGlobalRuleMetaData();
        SQLParserRule sqlParserRule = (SQLParserRule)globalRuleMetaData.getSingleRule(SQLParserRule.class);
        SQLStatement previewedStatement = sqlParserRule.getSQLParserEngine(databaseType).parse(((PreviewStatement)this.getSqlStatement()).getSql(), false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaData().getDatabases(), (SQLStatement)previewedStatement, (String)databaseName);
        QueryContext queryContext = new QueryContext(sqlStatementContext, ((PreviewStatement)this.getSqlStatement()).getSql(), Collections.emptyList());
        this.getConnectionSession().setQueryContext(queryContext);
        if (sqlStatementContext instanceof CursorAvailable && sqlStatementContext instanceof CursorDefinitionAware) {
            this.setUpCursorDefinition(sqlStatementContext);
        }
        if (!(database = ProxyContext.getInstance().getDatabase(this.getConnectionSession().getDatabaseName())).isComplete()) {
            throw new RuleNotExistedException();
        }
        ConfigurationProperties props = metaDataContexts.getMetaData().getProps();
        SQLFederationDeciderContext deciderContext = PreviewHandler.decide(queryContext, props, metaDataContexts.getMetaData().getDatabase(this.getConnectionSession().getDatabaseName()));
        Collection executionUnits = deciderContext.isUseSQLFederation() ? this.getFederationExecutionUnits(queryContext, databaseName, metaDataContexts) : this.kernelProcessor.generateExecutionContext(queryContext, database, globalRuleMetaData, props, this.getConnectionSession().getConnectionContext()).getExecutionUnits();
        return executionUnits.stream().map(this::buildRow).collect(Collectors.toList());
    }

    private static SQLFederationDeciderContext decide(QueryContext queryContext, ConfigurationProperties props, ShardingSphereDatabase database) {
        SQLFederationDeciderEngine deciderEngine = new SQLFederationDeciderEngine(database.getRuleMetaData().getRules(), props);
        return deciderEngine.decide(queryContext, database);
    }

    private void setUpCursorDefinition(SQLStatementContext<?> sqlStatementContext) {
        if (!((CursorAvailable)sqlStatementContext).getCursorName().isPresent()) {
            return;
        }
        String cursorName = ((CursorNameSegment)((CursorAvailable)sqlStatementContext).getCursorName().get()).getIdentifier().getValue().toLowerCase();
        CursorStatementContext cursorStatementContext = (CursorStatementContext)this.getConnectionSession().getConnectionContext().getCursorConnectionContext().getCursorDefinitions().get(cursorName);
        Preconditions.checkArgument((null != cursorStatementContext ? 1 : 0) != 0, (String)"Cursor %s does not exist.", (Object)cursorName);
        ((CursorDefinitionAware)sqlStatementContext).setUpCursorDefinition(cursorStatementContext);
    }

    private LocalDataQueryResultRow buildRow(ExecutionUnit unit) {
        return new LocalDataQueryResultRow(new Object[]{unit.getDataSourceName(), unit.getSqlUnit().getSql()});
    }

    private Collection<ExecutionUnit> getFederationExecutionUnits(QueryContext queryContext, String databaseName, MetaDataContexts metaDataContexts) throws SQLException {
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        boolean isReturnGeneratedKeys = sqlStatement instanceof MySQLInsertStatement;
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(isReturnGeneratedKeys, metaDataContexts);
        SQLFederationExecutorContext context = new SQLFederationExecutorContext(true, queryContext, metaDataContexts.getMetaData().getDatabases());
        DatabaseType databaseType = metaDataContexts.getMetaData().getDatabase(this.getDatabaseName()).getResourceMetaData().getDatabaseType();
        String schemaName = queryContext.getSqlStatementContext().getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)databaseName));
        EventBusContext eventBusContext = ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext();
        SQLFederationRule sqlFederationRule = (SQLFederationRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLFederationRule.class);
        SQLFederationExecutor sqlFederationExecutor = sqlFederationRule.getSQLFederationExecutor(databaseName, schemaName, metaDataContexts.getMetaData(), metaDataContexts.getShardingSphereData(), new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), false), eventBusContext);
        sqlFederationExecutor.executeQuery(prepareEngine, this.createPreviewFederationCallback(sqlStatement, databaseType, eventBusContext), context);
        return context.getExecutionUnits();
    }

    private JDBCExecutorCallback<ExecuteResult> createPreviewFederationCallback(SQLStatement sqlStatement, DatabaseType databaseType, EventBusContext eventBusContext) {
        return new JDBCExecutorCallback<ExecuteResult>(databaseType, sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown(), eventBusContext){

            protected ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return new JDBCStreamQueryResult(statement.executeQuery(sql));
            }

            protected Optional<ExecuteResult> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(boolean isReturnGeneratedKeys, MetaDataContexts metaDataContexts) {
        int maxConnectionsSizePerQuery = (Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (ExecutorConnectionManager)((JDBCBackendConnection)this.getConnectionSession().getBackendConnection()), (ExecutorStatementManager)((JDBCBackendStatement)this.getConnectionSession().getStatementManager()), (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), metaDataContexts.getMetaData().getDatabase(this.getDatabaseName()).getRuleMetaData().getRules(), metaDataContexts.getMetaData().getDatabase(this.getDatabaseName()).getResourceMetaData().getDatabaseType());
    }

    private String getDatabaseName() {
        String result;
        String string = result = !Strings.isNullOrEmpty((String)this.getConnectionSession().getDatabaseName()) ? this.getConnectionSession().getDatabaseName() : this.getConnectionSession().getDefaultDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(result)) {
            throw new UnknownDatabaseException(result);
        }
        return result;
    }
}

