/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rul.sql;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.parser.statement.rul.sql.ParseStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.SQLRULBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ParseDistSQLHandler
extends SQLRULBackendHandler<ParseStatement> {
    private static final String PARSED_STATEMENT = "parsed_statement";
    private static final String PARSED_STATEMENT_DETAIL = "parsed_statement_detail";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(PARSED_STATEMENT, PARSED_STATEMENT_DETAIL);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        SQLStatement parsedSqlStatement = this.parseSQL(contextManager);
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{parsedSqlStatement.getClass().getSimpleName(), new Gson().toJson((Object)parsedSqlStatement)}));
    }

    private SQLStatement parseSQL(ContextManager contextManager) {
        SQLParserRule sqlParserRule = (SQLParserRule)contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        String databaseType = this.getConnectionSession().getDatabaseType().getType();
        return sqlParserRule.getSQLParserEngine(databaseType).parse(((ParseStatement)this.getSqlStatement()).getSql(), false);
    }
}

