/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rul.sql;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.shardingsphere.distsql.parser.statement.rul.sql.FormatStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.SQLRULBackendHandler;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.api.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.api.SQLVisitorEngine;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;

public final class FormatSQLHandler
extends SQLRULBackendHandler<FormatStatement> {
    private static final String FORMATTED_RESULT = "formatted_result";

    @Override
    protected Collection<String> getColumnNames() {
        return Collections.singleton(FORMATTED_RESULT);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        String sql = ((FormatStatement)this.getSqlStatement()).getSql();
        String databaseType = this.getConnectionSession().getDatabaseType().getType();
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{this.formatSQL(sql, databaseType)}));
    }

    private Object formatSQL(String sql, String databaseType) {
        Properties props = new Properties();
        props.setProperty("parameterized", Boolean.FALSE.toString());
        return new SQLVisitorEngine(databaseType, "FORMAT", false, props).visit(this.parseSQL(sql, databaseType));
    }

    private ParseASTNode parseSQL(String sql, String databaseType) {
        return new SQLParserEngine(databaseType, new CacheOption(1, 1L)).parse(sql, false);
    }
}

