/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rul;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.rul.RULStatement;
import org.apache.shardingsphere.distsql.parser.statement.rul.sql.FormatStatement;
import org.apache.shardingsphere.distsql.parser.statement.rul.sql.ParseStatement;
import org.apache.shardingsphere.distsql.parser.statement.rul.sql.PreviewStatement;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.RULBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.sql.FormatSQLHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.sql.ParseDistSQLHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.sql.PreviewHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class RULBackendHandlerFactory {
    private static final Map<Class<? extends RULStatement>, Class<? extends RULBackendHandler<?>>> HANDLERS = new HashMap();

    public static ProxyBackendHandler newInstance(RULStatement sqlStatement, ConnectionSession connectionSession) {
        return RULBackendHandlerFactory.createRULBackendHandler(sqlStatement, connectionSession);
    }

    private static RULBackendHandler<?> newInstance(Class<? extends RULBackendHandler<?>> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new UnsupportedSQLOperationException(String.format("Can not find public constructor for class `%s`", clazz.getName()));
        }
    }

    private static RULBackendHandler<?> createRULBackendHandler(RULStatement sqlStatement, ConnectionSession connectionSession) {
        Class<? extends RULBackendHandler<?>> clazz = HANDLERS.get(sqlStatement.getClass());
        ShardingSpherePreconditions.checkState((null != clazz ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("Unsupported SQL statement : %s", sqlStatement.getClass().getCanonicalName())));
        RULBackendHandler<?> result = RULBackendHandlerFactory.newInstance(clazz);
        result.init(sqlStatement, connectionSession);
        return result;
    }

    @Generated
    private RULBackendHandlerFactory() {
    }

    static {
        HANDLERS.put(ParseStatement.class, ParseDistSQLHandler.class);
        HANDLERS.put(PreviewStatement.class, PreviewHandler.class);
        HANDLERS.put(FormatStatement.class, FormatSQLHandler.class);
    }
}

