/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rql.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryRule;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowRulesUsedResourceStatement;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.distsql.query.DatabaseDistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class RulesUsedResourceQueryResultSet
implements DatabaseDistSQLResultSet {
    private static final String SHARDING = "sharding";
    private static final String READWRITE_SPLITTING = "readwrite_splitting";
    private static final String DB_DISCOVERY = "db_discovery";
    private static final String ENCRYPT = "encrypt";
    private static final String SHADOW = "shadow";
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        LinkedList<Collection<Object>> data = new LinkedList<Collection<Object>>();
        ShowRulesUsedResourceStatement statement = (ShowRulesUsedResourceStatement)sqlStatement;
        String resourceName = statement.getResourceName().orElse(null);
        if (database.getResourceMetaData().getDataSources().containsKey(resourceName)) {
            data.addAll(this.getShardingData(database));
            data.addAll(this.getReadwriteSplittingData(database, resourceName));
            data.addAll(this.getDatabaseDiscoveryData(database, resourceName));
            data.addAll(this.getEncryptData(database));
            data.addAll(this.getShadowData(database, resourceName));
        }
        this.data = data.iterator();
    }

    private Collection<Collection<Object>> getShardingData(ShardingSphereDatabase database) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<Collection<Object>> result = new LinkedList<Collection<Object>>();
        ShardingRuleConfiguration config = (ShardingRuleConfiguration)((ShardingRule)rule.get()).getConfiguration();
        for (ShardingAutoTableRuleConfiguration each : config.getAutoTables()) {
            result.add(this.buildRow(SHARDING, each.getLogicTable()));
        }
        for (ShardingAutoTableRuleConfiguration each : config.getTables()) {
            result.add(this.buildRow(SHARDING, each.getLogicTable()));
        }
        return result;
    }

    private Collection<Collection<Object>> getReadwriteSplittingData(ShardingSphereDatabase database, String resourceName) {
        Optional rule = database.getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<Collection<Object>> result = new LinkedList<Collection<Object>>();
        ReadwriteSplittingRuleConfiguration config = (ReadwriteSplittingRuleConfiguration)((ReadwriteSplittingRule)rule.get()).getConfiguration();
        for (ReadwriteSplittingDataSourceRuleConfiguration each : config.getDataSources()) {
            if (null == each.getStaticStrategy()) continue;
            if (each.getStaticStrategy().getWriteDataSourceName().equalsIgnoreCase(resourceName)) {
                result.add(this.buildRow(READWRITE_SPLITTING, each.getName()));
            }
            if (!each.getStaticStrategy().getReadDataSourceNames().contains(resourceName)) continue;
            result.add(this.buildRow(READWRITE_SPLITTING, each.getName()));
        }
        return result;
    }

    private Collection<Collection<Object>> getDatabaseDiscoveryData(ShardingSphereDatabase database, String resourceName) {
        Optional rule = database.getRuleMetaData().findSingleRule(DatabaseDiscoveryRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        DatabaseDiscoveryRuleConfiguration config = (DatabaseDiscoveryRuleConfiguration)((DatabaseDiscoveryRule)rule.get()).getConfiguration();
        return config.getDataSources().stream().filter(each -> each.getDataSourceNames().contains(resourceName)).map(each -> this.buildRow(DB_DISCOVERY, each.getGroupName())).collect(Collectors.toList());
    }

    private Collection<Collection<Object>> getEncryptData(ShardingSphereDatabase database) {
        Optional rule = database.getRuleMetaData().findSingleRule(EncryptRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        EncryptRuleConfiguration config = (EncryptRuleConfiguration)((EncryptRule)rule.get()).getConfiguration();
        return config.getTables().stream().map(each -> this.buildRow(ENCRYPT, each.getName())).collect(Collectors.toList());
    }

    private Collection<Collection<Object>> getShadowData(ShardingSphereDatabase database, String resourceName) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShadowRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        ShadowRuleConfiguration config = (ShadowRuleConfiguration)((ShadowRule)rule.get()).getConfiguration();
        return config.getDataSources().entrySet().stream().filter(entry -> ((ShadowDataSourceConfiguration)entry.getValue()).getShadowDataSourceName().equalsIgnoreCase(resourceName) || ((ShadowDataSourceConfiguration)entry.getValue()).getProductionDataSourceName().equalsIgnoreCase(resourceName)).map(entry -> this.buildRow(SHADOW, (String)entry.getKey())).collect(Collectors.toList());
    }

    private Collection<Object> buildRow(String type, String name) {
        return Arrays.asList(type, name);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowRulesUsedResourceStatement.class.getName();
    }
}

