/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rql.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.CountSingleTableRuleStatement;
import org.apache.shardingsphere.infra.distsql.query.DatabaseDistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CountSingleTableRuleQueryResultSet
implements DatabaseDistSQLResultSet {
    private static final String SINGLE_TABLE = "single_table";
    private Iterator<Map.Entry<String, LinkedList<Object>>> data = Collections.emptyIterator();

    public Collection<String> getColumnNames() {
        return Arrays.asList("rule_name", "database", "count");
    }

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(SingleTableRule.class);
        LinkedHashMap result = new LinkedHashMap();
        rule.ifPresent(optional -> this.addSingleTableData(result, database.getName(), (SingleTableRule)rule.get()));
        this.data = result.entrySet().iterator();
    }

    private void addSingleTableData(Map<String, LinkedList<Object>> rowMap, String databaseName, SingleTableRule rule) {
        rowMap.compute(SINGLE_TABLE, (key, value) -> this.buildRow((LinkedList<Object>)value, databaseName, rule.getAllTables().size()));
    }

    private LinkedList<Object> buildRow(LinkedList<Object> value, String databaseName, int count) {
        if (null == value) {
            return new LinkedList<Object>(Arrays.asList(databaseName, count));
        }
        value.set(1, (Integer)value.get(1) + count);
        return value;
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        Map.Entry<String, LinkedList<Object>> entry = this.data.next();
        entry.getValue().addFirst(entry.getKey());
        return entry.getValue();
    }

    public String getType() {
        return CountSingleTableRuleStatement.class.getName();
    }
}

