/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionUpdaterFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleDefinitionBackendHandler<T extends RuleDefinitionStatement>
extends DatabaseRequiredBackendHandler<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleDefinitionBackendHandler.class);

    public RuleDefinitionBackendHandler(T sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
    }

    @Override
    protected ResponseHeader execute(String databaseName, T sqlStatement) {
        RuleDefinitionUpdater ruleDefinitionUpdater = RuleDefinitionUpdaterFactory.getInstance(sqlStatement);
        Class ruleConfigClass = ruleDefinitionUpdater.getRuleConfigurationClass();
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(databaseName);
        RuleConfiguration currentRuleConfig = this.findCurrentRuleConfiguration(database, ruleConfigClass).orElse(null);
        ruleDefinitionUpdater.checkSQLStatement(database, sqlStatement, currentRuleConfig);
        if (this.getRefreshStatus((SQLStatement)sqlStatement, currentRuleConfig, (RuleDefinitionUpdater<?, ?>)ruleDefinitionUpdater)) {
            Collection<RuleConfiguration> alteredConfigs = this.processSQLStatement(database, sqlStatement, ruleDefinitionUpdater, currentRuleConfig);
            this.persistRuleConfigurationChange(databaseName, alteredConfigs);
        }
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private Optional<RuleConfiguration> findCurrentRuleConfiguration(ShardingSphereDatabase database, Class<? extends RuleConfiguration> ruleConfigClass) {
        for (RuleConfiguration each : database.getRuleMetaData().getConfigurations()) {
            if (!ruleConfigClass.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Collection<RuleConfiguration> processSQLStatement(ShardingSphereDatabase database, T sqlStatement, RuleDefinitionUpdater updater, RuleConfiguration currentRuleConfig) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>(database.getRuleMetaData().getConfigurations());
        if (updater instanceof RuleDefinitionCreateUpdater) {
            if (null != currentRuleConfig) {
                result.remove(currentRuleConfig);
            }
            result.add(this.processCreate(sqlStatement, (RuleDefinitionCreateUpdater)updater, currentRuleConfig));
        } else if (updater instanceof RuleDefinitionAlterUpdater) {
            result.remove(currentRuleConfig);
            result.add(this.processAlter(sqlStatement, (RuleDefinitionAlterUpdater)updater, currentRuleConfig));
        } else if (updater instanceof RuleDefinitionDropUpdater) {
            this.processDrop(result, sqlStatement, (RuleDefinitionDropUpdater)updater, currentRuleConfig);
        } else {
            throw new UnsupportedSQLOperationException(String.format("Cannot support RDL updater type `%s`", updater.getClass().getCanonicalName()));
        }
        ProxyContext.getInstance().getContextManager().alterRuleConfiguration(database.getName(), result);
        return result;
    }

    private RuleConfiguration processCreate(T sqlStatement, RuleDefinitionCreateUpdater updater, RuleConfiguration currentRuleConfig) {
        RuleConfiguration toBeCreatedRuleConfig = updater.buildToBeCreatedRuleConfiguration(sqlStatement);
        if (null == currentRuleConfig) {
            return toBeCreatedRuleConfig;
        }
        updater.updateCurrentRuleConfiguration(currentRuleConfig, toBeCreatedRuleConfig);
        return currentRuleConfig;
    }

    private RuleConfiguration processAlter(T sqlStatement, RuleDefinitionAlterUpdater updater, RuleConfiguration currentRuleConfig) {
        RuleConfiguration toBeAlteredRuleConfig = updater.buildToBeAlteredRuleConfiguration(sqlStatement);
        updater.updateCurrentRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
        return currentRuleConfig;
    }

    private void processDrop(Collection<RuleConfiguration> configs, T sqlStatement, RuleDefinitionDropUpdater updater, RuleConfiguration currentRuleConfig) {
        if (!updater.hasAnyOneToBeDropped(sqlStatement, currentRuleConfig)) {
            return;
        }
        if (updater.updateCurrentRuleConfiguration(sqlStatement, currentRuleConfig)) {
            configs.remove(currentRuleConfig);
        }
    }

    private void persistRuleConfigurationChange(String databaseName, Collection<RuleConfiguration> alteredConfigs) {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        metaDataContexts.getPersistService().getDatabaseRulePersistService().persist(metaDataContexts.getMetaData().getActualDatabaseName(databaseName), alteredConfigs);
    }

    private boolean getRefreshStatus(SQLStatement sqlStatement, RuleConfiguration currentRuleConfig, RuleDefinitionUpdater<?, ?> updater) {
        if (updater instanceof RuleDefinitionDropUpdater) {
            return ((RuleDefinitionDropUpdater)updater).hasAnyOneToBeDropped(sqlStatement, currentRuleConfig);
        }
        return true;
    }
}

