/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.rule;

import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;

public final class DropDefaultSingleTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropDefaultSingleTableRuleStatement, SingleTableRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) {
        this.checkCurrentRuleConfiguration(database.getName(), sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, DropDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) {
        if (!sqlStatement.isIfExists()) {
            ShardingSpherePreconditions.checkState((null != currentRuleConfig && currentRuleConfig.getDefaultDataSource().isPresent() ? 1 : 0) != 0, () -> new MissingRequiredRuleException("single table", databaseName));
        }
    }

    public boolean updateCurrentRuleConfiguration(DropDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultDataSource(null);
        return false;
    }

    public boolean hasAnyOneToBeDropped(DropDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && currentRuleConfig.getDefaultDataSource().isPresent();
    }

    public Class<SingleTableRuleConfiguration> getRuleConfigurationClass() {
        return SingleTableRuleConfiguration.class;
    }

    public String getType() {
        return DropDefaultSingleTableRuleStatement.class.getName();
    }
}

