/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.rule;

import java.util.Collections;
import java.util.Set;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.CreateDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;

public final class CreateDefaultSingleTableRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDefaultSingleTableRuleStatement, SingleTableRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) {
        this.checkResourceExist(database, sqlStatement);
        this.checkDefaultResourceDuplicate(database.getName(), currentRuleConfig);
    }

    private void checkResourceExist(ShardingSphereDatabase database, CreateDefaultSingleTableRuleStatement sqlStatement) {
        Set resourceNames = database.getResourceMetaData().getDataSources().keySet();
        ShardingSpherePreconditions.checkState((boolean)resourceNames.contains(sqlStatement.getDefaultResource()), () -> new MissingRequiredResourcesException(database.getName(), Collections.singleton(sqlStatement.getDefaultResource())));
    }

    private void checkDefaultResourceDuplicate(String databaseName, SingleTableRuleConfiguration currentRuleConfig) {
        if (null != currentRuleConfig) {
            ShardingSpherePreconditions.checkState((!currentRuleConfig.getDefaultDataSource().isPresent() ? 1 : 0) != 0, () -> new DuplicateRuleException("default single table rule", databaseName));
        }
    }

    public SingleTableRuleConfiguration buildToBeCreatedRuleConfiguration(CreateDefaultSingleTableRuleStatement sqlStatement) {
        SingleTableRuleConfiguration result = new SingleTableRuleConfiguration();
        result.setDefaultDataSource(sqlStatement.getDefaultResource());
        return result;
    }

    public void updateCurrentRuleConfiguration(SingleTableRuleConfiguration currentRuleConfig, SingleTableRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.setDefaultDataSource((String)toBeCreatedRuleConfig.getDefaultDataSource().orElse(null));
    }

    public Class<SingleTableRuleConfiguration> getRuleConfigurationClass() {
        return SingleTableRuleConfiguration.class;
    }

    public String getType() {
        return CreateDefaultSingleTableRuleStatement.class.getName();
    }
}

