/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.rule;

import java.util.Collections;
import java.util.Set;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;

public final class AlterDefaultSingleTableRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDefaultSingleTableRuleStatement, SingleTableRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, AlterDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        this.checkConfigurationExist(databaseName, currentRuleConfig);
        this.checkResourceExist(database, sqlStatement);
        this.checkDefaultResourceExist(databaseName, currentRuleConfig);
    }

    private void checkConfigurationExist(String databaseName, SingleTableRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException(databaseName, "single table"));
    }

    private void checkResourceExist(ShardingSphereDatabase database, AlterDefaultSingleTableRuleStatement sqlStatement) {
        Set resourceNames = database.getResourceMetaData().getDataSources().keySet();
        ShardingSpherePreconditions.checkState((boolean)resourceNames.contains(sqlStatement.getDefaultResource()), () -> new MissingRequiredResourcesException(database.getName(), Collections.singleton(sqlStatement.getDefaultResource())));
    }

    private void checkDefaultResourceExist(String databaseName, SingleTableRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkState((boolean)currentRuleConfig.getDefaultDataSource().isPresent(), () -> new MissingRequiredRuleException("single table", databaseName));
    }

    public SingleTableRuleConfiguration buildToBeAlteredRuleConfiguration(AlterDefaultSingleTableRuleStatement sqlStatement) {
        SingleTableRuleConfiguration result = new SingleTableRuleConfiguration();
        result.setDefaultDataSource(sqlStatement.getDefaultResource());
        return result;
    }

    public void updateCurrentRuleConfiguration(SingleTableRuleConfiguration currentRuleConfig, SingleTableRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.setDefaultDataSource((String)toBeCreatedRuleConfig.getDefaultDataSource().get());
    }

    public Class<SingleTableRuleConfiguration> getRuleConfigurationClass() {
        return SingleTableRuleConfiguration.class;
    }

    public String getType() {
        return AlterDefaultSingleTableRuleStatement.class.getName();
    }
}

