/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.resource;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.ResourceInUsedException;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.server.ShardingSphereServerException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropResourceBackendHandler
extends DatabaseRequiredBackendHandler<DropResourceStatement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DropResourceBackendHandler.class);

    public DropResourceBackendHandler(DropResourceStatement sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
    }

    @Override
    public ResponseHeader execute(String databaseName, DropResourceStatement sqlStatement) {
        Collection toBeDroppedResourceNames = sqlStatement.getNames();
        this.check(databaseName, toBeDroppedResourceNames, sqlStatement.isIgnoreSingleTables(), sqlStatement.isIfExists());
        try {
            ProxyContext.getInstance().getContextManager().dropResources(databaseName, toBeDroppedResourceNames);
        }
        catch (SQLException | ShardingSphereServerException ex) {
            log.error("Drop resource failed", ex);
            throw new InvalidResourcesException(Collections.singleton(ex.getMessage()));
        }
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void check(String databaseName, Collection<String> toBeDroppedResourceNames, boolean ignoreSingleTables, boolean allowNotExist) {
        if (!allowNotExist) {
            this.checkResourceNameExisted(databaseName, toBeDroppedResourceNames);
        }
        this.checkResourceNameNotInUse(databaseName, toBeDroppedResourceNames, ignoreSingleTables);
    }

    private void checkResourceNameExisted(String databaseName, Collection<String> resourceNames) {
        Map resources = ProxyContext.getInstance().getDatabase(databaseName).getResourceMetaData().getDataSources();
        Collection notExistedResourceNames = resourceNames.stream().filter(each -> !resources.containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedResourceNames.isEmpty(), () -> new MissingRequiredResourcesException(databaseName, notExistedResourceNames));
    }

    private void checkResourceNameNotInUse(String databaseName, Collection<String> toBeDroppedResourceNames, boolean ignoreSingleTables) {
        Multimap<String, String> inUsedMultimap = this.getInUsedResources(databaseName);
        Set inUsedResourceNames = inUsedMultimap.keySet();
        inUsedResourceNames.retainAll(toBeDroppedResourceNames);
        if (!inUsedResourceNames.isEmpty()) {
            if (ignoreSingleTables) {
                this.checkResourceNameNotInUseIgnoreSingleTableRule(new HashSet<String>(inUsedResourceNames), inUsedMultimap);
            } else {
                String firstResource = (String)inUsedResourceNames.iterator().next();
                throw new ResourceInUsedException(firstResource, inUsedMultimap.get((Object)firstResource));
            }
        }
    }

    private void checkResourceNameNotInUseIgnoreSingleTableRule(Collection<String> inUsedResourceNames, Multimap<String, String> inUsedMultimap) {
        for (String each : inUsedResourceNames) {
            Collection inUsedRules = inUsedMultimap.get((Object)each);
            inUsedRules.remove(SingleTableRule.class.getSimpleName());
            ShardingSpherePreconditions.checkState((boolean)inUsedRules.isEmpty(), () -> new ResourceInUsedException(each, inUsedRules));
        }
    }

    private Multimap<String, String> getInUsedResources(String databaseName) {
        LinkedListMultimap result = LinkedListMultimap.create();
        for (ShardingSphereRule each : ProxyContext.getInstance().getDatabase(databaseName).getRuleMetaData().getRules()) {
            Collection<String> inUsedResourceNames;
            if (each instanceof DataSourceContainedRule) {
                inUsedResourceNames = this.getInUsedResourceNames((DataSourceContainedRule)each);
                inUsedResourceNames.forEach(arg_0 -> DropResourceBackendHandler.lambda$getInUsedResources$3((Multimap)result, each, arg_0));
            }
            if (!(each instanceof DataNodeContainedRule)) continue;
            inUsedResourceNames = this.getInUsedResourceNames((DataNodeContainedRule)each);
            inUsedResourceNames.forEach(arg_0 -> DropResourceBackendHandler.lambda$getInUsedResources$4((Multimap)result, each, arg_0));
        }
        return result;
    }

    private Collection<String> getInUsedResourceNames(DataSourceContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getDataSourceMapper().values()) {
            result.addAll(each);
        }
        return result;
    }

    private Collection<String> getInUsedResourceNames(DataNodeContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getAllDataNodes().values()) {
            result.addAll(each.stream().map(DataNode::getDataSourceName).collect(Collectors.toList()));
        }
        return result;
    }

    private static /* synthetic */ void lambda$getInUsedResources$4(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }

    private static /* synthetic */ void lambda$getInUsedResources$3(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }
}

