/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.metadata.url.StandardJdbcUrlParser;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesValidator;
import org.apache.shardingsphere.infra.distsql.exception.resource.DuplicateResourceException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.server.ShardingSphereServerException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ResourceSegmentsConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlterResourceBackendHandler
extends DatabaseRequiredBackendHandler<AlterResourceStatement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlterResourceBackendHandler.class);
    private final DatabaseType databaseType;
    private final DataSourcePropertiesValidator validator;

    public AlterResourceBackendHandler(AlterResourceStatement sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
        this.databaseType = connectionSession.getDatabaseType();
        this.validator = new DataSourcePropertiesValidator();
    }

    @Override
    public ResponseHeader execute(String databaseName, AlterResourceStatement sqlStatement) {
        this.checkSQLStatement(databaseName, sqlStatement);
        Map dataSourcePropsMap = ResourceSegmentsConverter.convert((DatabaseType)this.databaseType, (Collection)sqlStatement.getDataSources());
        this.validator.validate(dataSourcePropsMap, this.databaseType);
        try {
            ProxyContext.getInstance().getContextManager().updateResources(databaseName, dataSourcePropsMap);
        }
        catch (SQLException | ShardingSphereServerException ex) {
            log.error("Alter resource failed", ex);
            throw new InvalidResourcesException(Collections.singleton(ex.getMessage()));
        }
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void checkSQLStatement(String databaseName, AlterResourceStatement sqlStatement) {
        Collection<String> toBeAlteredResourceNames = this.getToBeAlteredResourceNames(sqlStatement);
        this.checkToBeAlteredDuplicateResourceNames(toBeAlteredResourceNames);
        this.checkResourceNameExisted(databaseName, toBeAlteredResourceNames);
        this.checkDatabase(databaseName, sqlStatement);
    }

    private void checkDatabase(String databaseName, AlterResourceStatement sqlStatement) {
        Map resources = ProxyContext.getInstance().getDatabase(databaseName).getResourceMetaData().getDataSources();
        Collection invalid = sqlStatement.getDataSources().stream().collect(Collectors.toMap(DataSourceSegment::getName, each -> each)).entrySet().stream().filter(each -> !this.isIdenticalDatabase((DataSourceSegment)each.getValue(), (DataSource)resources.get(each.getKey()))).map(Map.Entry::getKey).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)invalid.isEmpty(), () -> new InvalidResourcesException(Collections.singleton(String.format("Cannot alter the database of %s", invalid))));
    }

    private Collection<String> getToBeAlteredResourceNames(AlterResourceStatement sqlStatement) {
        return sqlStatement.getDataSources().stream().map(DataSourceSegment::getName).collect(Collectors.toList());
    }

    private void checkToBeAlteredDuplicateResourceNames(Collection<String> resourceNames) {
        Collection<String> duplicateResourceNames = this.getDuplicateResourceNames(resourceNames);
        ShardingSpherePreconditions.checkState((boolean)duplicateResourceNames.isEmpty(), () -> new DuplicateResourceException(duplicateResourceNames));
    }

    private Collection<String> getDuplicateResourceNames(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> resourceNames.stream().filter(each::equals).count() > 1L).collect(Collectors.toList());
    }

    private void checkResourceNameExisted(String databaseName, Collection<String> resourceNames) {
        Map resources = ProxyContext.getInstance().getDatabase(databaseName).getResourceMetaData().getDataSources();
        Collection notExistedResourceNames = resourceNames.stream().filter(each -> !resources.containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedResourceNames.isEmpty(), () -> new MissingRequiredResourcesException(databaseName, notExistedResourceNames));
    }

    private boolean isIdenticalDatabase(DataSourceSegment segment, DataSource dataSource) {
        String url;
        JdbcUrl dataSourceJdbcUrl;
        String hostName = null;
        String port = null;
        String database = null;
        if (segment instanceof HostnameAndPortBasedDataSourceSegment) {
            hostName = ((HostnameAndPortBasedDataSourceSegment)segment).getHostname();
            port = ((HostnameAndPortBasedDataSourceSegment)segment).getPort();
            database = ((HostnameAndPortBasedDataSourceSegment)segment).getDatabase();
        }
        if (segment instanceof URLBasedDataSourceSegment) {
            JdbcUrl segmentJdbcUrl = new StandardJdbcUrlParser().parse(((URLBasedDataSourceSegment)segment).getUrl());
            hostName = segmentJdbcUrl.getHostname();
            port = String.valueOf(segmentJdbcUrl.getPort());
            database = segmentJdbcUrl.getDatabase();
        }
        return hostName.equals((dataSourceJdbcUrl = new StandardJdbcUrlParser().parse(url = String.valueOf(DataSourcePropertiesCreator.create((DataSource)dataSource).getConnectionPropertySynonyms().getStandardProperties().get("url")))).getHostname()) && port.equals(String.valueOf(dataSourceJdbcUrl.getPort())) && database.equals(dataSourceJdbcUrl.getDatabase());
    }
}

