/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.resource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesValidator;
import org.apache.shardingsphere.infra.distsql.exception.resource.DuplicateResourceException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.server.ShardingSphereServerException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ResourceSegmentsConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddResourceBackendHandler
extends DatabaseRequiredBackendHandler<AddResourceStatement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddResourceBackendHandler.class);
    private final DatabaseType databaseType;
    private final DataSourcePropertiesValidator validator;

    public AddResourceBackendHandler(AddResourceStatement sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
        this.databaseType = connectionSession.getDatabaseType();
        this.validator = new DataSourcePropertiesValidator();
    }

    @Override
    public ResponseHeader execute(String databaseName, AddResourceStatement sqlStatement) {
        this.checkSQLStatement(databaseName, sqlStatement);
        Map dataSourcePropsMap = ResourceSegmentsConverter.convert((DatabaseType)this.databaseType, (Collection)sqlStatement.getDataSources());
        DatabaseType storeType = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData().getDatabaseType();
        this.validator.validate(dataSourcePropsMap, storeType);
        try {
            ProxyContext.getInstance().getContextManager().addResources(databaseName, dataSourcePropsMap);
        }
        catch (SQLException | ShardingSphereServerException ex) {
            log.error("Add resource failed", ex);
            throw new InvalidResourcesException(Collections.singleton(ex.getMessage()));
        }
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void checkSQLStatement(String databaseName, AddResourceStatement sqlStatement) {
        ArrayList<String> dataSourceNames = new ArrayList<String>(sqlStatement.getDataSources().size());
        HashSet<String> duplicateDataSourceNames = new HashSet<String>(sqlStatement.getDataSources().size(), 1.0f);
        for (DataSourceSegment each : sqlStatement.getDataSources()) {
            if (dataSourceNames.contains(each.getName()) || ProxyContext.getInstance().getDatabase(databaseName).getResourceMetaData().getDataSources().containsKey(each.getName())) {
                duplicateDataSourceNames.add(each.getName());
            }
            dataSourceNames.add(each.getName());
        }
        ShardingSpherePreconditions.checkState((boolean)duplicateDataSourceNames.isEmpty(), () -> new DuplicateResourceException(duplicateDataSourceNames));
    }
}

