/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.UnlabelInstanceStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;

public final class UnlabelInstanceHandler
extends UpdatableRALBackendHandler<UnlabelInstanceStatement> {
    @Override
    protected void update(ContextManager contextManager) {
        MetaDataPersistService persistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getPersistService();
        ShardingSpherePreconditions.checkState((null != persistService.getRepository() && !(persistService.getRepository() instanceof StandalonePersistRepository) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Labels can only be removed in cluster mode"));
        String instanceId = ((UnlabelInstanceStatement)this.getSqlStatement()).getInstanceId();
        Optional computeNodeInstance = contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId);
        if (computeNodeInstance.isPresent()) {
            LinkedHashSet labels = new LinkedHashSet(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            if (((UnlabelInstanceStatement)this.getSqlStatement()).getLabels().isEmpty()) {
                contextManager.getInstanceContext().getEventBusContext().post((Object)new LabelsChangedEvent(instanceId, Collections.emptyList()));
            } else {
                labels.removeAll(((UnlabelInstanceStatement)this.getSqlStatement()).getLabels());
                contextManager.getInstanceContext().getEventBusContext().post((Object)new LabelsChangedEvent(instanceId, new ArrayList(labels)));
            }
        }
    }
}

