/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.SetVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.util.props.TypedPropertyKey;
import org.apache.shardingsphere.infra.util.props.TypedPropertyValue;
import org.apache.shardingsphere.infra.util.props.exception.TypedPropertyValueException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.InvalidValueException;
import org.apache.shardingsphere.proxy.backend.exception.UnsupportedVariableException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class SetVariableHandler
extends UpdatableRALBackendHandler<SetVariableStatement> {
    @Override
    protected void update(ContextManager contextManager) {
        Enum<?> enumType = this.getEnumType(((SetVariableStatement)this.getSqlStatement()).getName());
        if (enumType instanceof ConfigurationPropertyKey) {
            this.handleConfigurationProperty((ConfigurationPropertyKey)enumType, ((SetVariableStatement)this.getSqlStatement()).getValue());
        } else if (enumType instanceof VariableEnum) {
            this.handleVariables();
        } else {
            throw new UnsupportedVariableException(((SetVariableStatement)this.getSqlStatement()).getName());
        }
    }

    private Enum<?> getEnumType(String name) {
        try {
            return ConfigurationPropertyKey.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return VariableEnum.getValueOf(name);
        }
    }

    private void handleConfigurationProperty(ConfigurationPropertyKey propertyKey, String value) {
        ContextManager contextManager = ProxyContext.getInstance().getContextManager();
        MetaDataContexts metaDataContexts = contextManager.getMetaDataContexts();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metaDataContexts.getMetaData().getProps().getProps());
        props.put(propertyKey.getKey(), this.getValue(propertyKey, value));
        contextManager.alterProperties(props);
        MetaDataPersistService persistService = metaDataContexts.getPersistService();
        if (null != persistService.getPropsService()) {
            persistService.getPropsService().persist(props);
        }
    }

    private Object getValue(ConfigurationPropertyKey propertyKey, String value) {
        try {
            return new TypedPropertyValue((TypedPropertyKey)propertyKey, value).getValue();
        }
        catch (TypedPropertyValueException ex) {
            throw new InvalidValueException(value);
        }
    }

    private void handleVariables() {
        VariableEnum variable = VariableEnum.getValueOf(((SetVariableStatement)this.getSqlStatement()).getName());
        switch (variable) {
            case AGENT_PLUGINS_ENABLED: {
                Boolean agentPluginsEnabled = BooleanUtils.toBooleanObject((String)((SetVariableStatement)this.getSqlStatement()).getValue());
                SystemPropertyUtil.setSystemProperty(variable.name(), null == agentPluginsEnabled ? Boolean.FALSE.toString() : agentPluginsEnabled.toString());
                break;
            }
            case TRANSACTION_TYPE: {
                this.getConnectionSession().getTransactionStatus().setTransactionType(this.getTransactionType(((SetVariableStatement)this.getSqlStatement()).getValue()));
                break;
            }
            default: {
                throw new UnsupportedVariableException(((SetVariableStatement)this.getSqlStatement()).getName());
            }
        }
    }

    private TransactionType getTransactionType(String transactionTypeName) throws UnsupportedVariableException {
        try {
            return TransactionType.valueOf((String)transactionTypeName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedVariableException(transactionTypeName);
        }
    }
}

