/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.RuleExportEngine;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.service.StorageNodeStatusService;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeRole;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceDisabledEvent;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.status.SetReadwriteSplittingStatusStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class SetReadwriteSplittingStatusHandler
extends UpdatableRALBackendHandler<SetReadwriteSplittingStatusStatement> {
    private static final String DISABLE = "DISABLE";

    @Override
    protected void update(ContextManager contextManager) {
        String databaseName = ((SetReadwriteSplittingStatusStatement)this.getSqlStatement()).getDatabase().isPresent() ? ((DatabaseSegment)((SetReadwriteSplittingStatusStatement)this.getSqlStatement()).getDatabase().get()).getIdentifier().getValue() : this.getConnectionSession().getDatabaseName();
        String toBeUpdatedResource = ((SetReadwriteSplittingStatusStatement)this.getSqlStatement()).getResourceName();
        this.checkModeAndPersistRepository(contextManager);
        this.checkDatabaseName(databaseName);
        this.checkReadwriteSplittingRule(contextManager, databaseName);
        Map<String, String> replicaResources = this.getReplicaResources(contextManager, databaseName);
        Map<String, String> disabledResources = this.getDisabledResources(contextManager, databaseName);
        Map<String, String> autoAwareResources = this.getAutoAwareResources(contextManager, databaseName);
        boolean isDisable = DISABLE.equals(((SetReadwriteSplittingStatusStatement)this.getSqlStatement()).getStatus());
        if (isDisable) {
            this.checkDisable(contextManager, databaseName, disabledResources.keySet(), toBeUpdatedResource, replicaResources);
        } else {
            this.checkEnable(contextManager, databaseName, disabledResources, toBeUpdatedResource);
        }
        Collection<String> groupNames = this.getGroupNames(toBeUpdatedResource, replicaResources, disabledResources, autoAwareResources);
        this.updateStatus(databaseName, groupNames, toBeUpdatedResource, isDisable);
    }

    private void checkReadwriteSplittingRule(ContextManager contextManager, String databaseName) {
        Optional rule = contextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class);
        ShardingSpherePreconditions.checkState((boolean)rule.isPresent(), () -> new UnsupportedSQLOperationException("The current schema has no read_write splitting rules"));
    }

    private void checkModeAndPersistRepository(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((boolean)contextManager.getInstanceContext().isCluster(), () -> new UnsupportedSQLOperationException("Mode must be `Cluster`"));
    }

    private void checkDatabaseName(String databaseName) {
        if (Strings.isNullOrEmpty((String)databaseName)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(databaseName)) {
            throw new UnknownDatabaseException(databaseName);
        }
    }

    private Map<String, String> getReplicaResources(ContextManager contextManager, String databaseName) {
        Map<String, Map<String, String>> readwriteSplittingRules = this.getExportedReadwriteSplittingRules(contextManager, databaseName);
        HashMap<String, String> result = new HashMap<String, String>();
        readwriteSplittingRules.entrySet().stream().filter(entry -> !((Map)entry.getValue()).isEmpty()).forEach(entry -> this.addReplicaResource((Map<String, String>)result, (Map.Entry<String, Map<String, String>>)entry));
        return result;
    }

    private Map<String, String> getAutoAwareResources(ContextManager contextManager, String databaseName) {
        Map<String, Map<String, String>> readwriteSplittingRules = this.getExportedReadwriteSplittingRules(contextManager, databaseName);
        HashMap<String, String> result = new HashMap<String, String>();
        readwriteSplittingRules.values().stream().filter(each -> each.containsKey("auto_aware_data_source_name")).forEach(each -> Splitter.on((String)",").splitToList((CharSequence)each.get("replica_data_source_names")).forEach(each1 -> this.put(result, (String)each1, (String)each.get("auto_aware_data_source_name"))));
        return result;
    }

    private Map<String, String> getDisabledResources(ContextManager contextManager, String databaseName) {
        MetaDataPersistService persistService = contextManager.getMetaDataContexts().getPersistService();
        return this.getDisabledStorageNodes(databaseName, persistService).stream().collect(Collectors.toMap(QualifiedDatabase::getDataSourceName, QualifiedDatabase::getGroupName, (value1, value2) -> String.join((CharSequence)",", value1, value2)));
    }

    private void checkEnable(ContextManager contextManager, String databaseName, Map<String, String> disabledResources, String toBeEnabledResource) {
        this.checkResourceExists(contextManager, databaseName, toBeEnabledResource);
        this.checkIsNotDisabled(disabledResources.keySet(), toBeEnabledResource);
    }

    private void checkResourceExists(ContextManager contextManager, String databaseName, String toBeDisabledResource) {
        Collection notExistedResources = contextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData().getNotExistedResources(Collections.singleton(toBeDisabledResource));
        ShardingSpherePreconditions.checkState((boolean)notExistedResources.isEmpty(), () -> new MissingRequiredResourcesException(databaseName, Collections.singleton(toBeDisabledResource)));
    }

    private void checkIsNotDisabled(Collection<String> disabledResources, String toBeEnabledResource) {
        ShardingSpherePreconditions.checkState((boolean)disabledResources.contains(toBeEnabledResource), () -> new UnsupportedSQLOperationException(String.format("`%s` is not disabled", toBeEnabledResource)));
    }

    private void checkDisable(ContextManager contextManager, String databaseName, Collection<String> disabledResources, String toBeDisabledResource, Map<String, String> replicaResources) {
        this.checkResourceExists(contextManager, databaseName, toBeDisabledResource);
        this.checkIsDisabled(replicaResources, disabledResources, toBeDisabledResource);
        this.checkIsReplicaResource(replicaResources, toBeDisabledResource);
        this.checkIsLastResource(replicaResources, toBeDisabledResource);
    }

    private void checkIsDisabled(Map<String, String> replicaResources, Collection<String> disabledResources, String toBeDisabledResource) {
        String toBeDisableResourceRuleNames = replicaResources.get(toBeDisabledResource);
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)toBeDisableResourceRuleNames) || !disabledResources.contains(toBeDisabledResource) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("`%s` has been disabled", toBeDisabledResource)));
    }

    private void checkIsReplicaResource(Map<String, String> replicaResources, String toBeDisabledResource) {
        ShardingSpherePreconditions.checkState((boolean)replicaResources.containsKey(toBeDisabledResource), () -> new UnsupportedSQLOperationException(String.format("`%s` is not used as a read resource by any read-write separation rules,cannot be disabled", toBeDisabledResource)));
    }

    private void checkIsLastResource(Map<String, String> replicaResources, String toBeDisabledResource) {
        Collection onlyOneResourceRules = this.getOnlyOneResourceRules(replicaResources);
        List toBeDisabledResourceRuleNames = Splitter.on((String)",").trimResults().splitToList((CharSequence)replicaResources.get(toBeDisabledResource));
        Collection finalOnlyOneResourceRules = onlyOneResourceRules = (Collection)onlyOneResourceRules.stream().filter(toBeDisabledResourceRuleNames::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)onlyOneResourceRules.isEmpty(), () -> new UnsupportedSQLOperationException(String.format("`%s` is the last read resource in `%s`, cannot be disabled", toBeDisabledResource, finalOnlyOneResourceRules)));
    }

    private Collection<String> getGroupNames(String toBeDisableResource, Map<String, String> replicaResources, Map<String, String> disabledResources, Map<String, String> autoAwareResources) {
        String groupNames = autoAwareResources.getOrDefault(toBeDisableResource, replicaResources.getOrDefault(toBeDisableResource, disabledResources.get(toBeDisableResource)));
        return Splitter.on((String)",").splitToList((CharSequence)groupNames);
    }

    private void updateStatus(String databaseName, Collection<String> groupNames, String toBeDisableResource, boolean isDisable) {
        groupNames.forEach(each -> {
            StorageNodeDataSource storageNodeDataSource = new StorageNodeDataSource(StorageNodeRole.MEMBER, isDisable ? StorageNodeStatus.DISABLED : StorageNodeStatus.ENABLED);
            ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext().post((Object)new DataSourceDisabledEvent(databaseName, each, toBeDisableResource, storageNodeDataSource));
        });
    }

    private Collection<QualifiedDatabase> getDisabledStorageNodes(String databaseName, MetaDataPersistService persistService) {
        Map storageNodes = new StorageNodeStatusService((ClusterPersistRepository)persistService.getRepository()).loadStorageNodes();
        return storageNodes.entrySet().stream().filter(each -> StorageNodeStatus.DISABLED.name().equalsIgnoreCase(((StorageNodeDataSource)each.getValue()).getStatus())).map(each -> new QualifiedDatabase((String)each.getKey())).filter(each -> databaseName.equalsIgnoreCase(each.getDatabaseName())).collect(Collectors.toList());
    }

    private Map<String, Map<String, String>> getExportedReadwriteSplittingRules(ContextManager contextManager, String databaseName) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        contextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class).filter(each -> new RuleExportEngine((ExportableRule)each).containExportableKey(Arrays.asList("dynamic_readwrite_splitting_rules", "static_readwrite_splitting_rules"))).map(each -> new RuleExportEngine((ExportableRule)each).export(Arrays.asList("dynamic_readwrite_splitting_rules", "static_readwrite_splitting_rules"))).ifPresent(optional -> {
            result.putAll(optional.getOrDefault("dynamic_readwrite_splitting_rules", Collections.emptyMap()));
            result.putAll(optional.getOrDefault("static_readwrite_splitting_rules", Collections.emptyMap()));
        });
        return result;
    }

    private Collection<String> getOnlyOneResourceRules(Map<String, String> replicaResources) {
        return replicaResources.values().stream().map(databaseName -> Arrays.stream(databaseName.split(",")).collect(Collectors.toMap(each -> each, each -> 1)).entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() <= 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void addReplicaResource(Map<String, String> replicaResources, Map.Entry<String, Map<String, String>> readwriteSplittingRule) {
        readwriteSplittingRule.getValue().entrySet().stream().filter(entry -> "replica_data_source_names".equals(entry.getKey())).map(entry -> Arrays.asList(((String)entry.getValue()).split(","))).flatMap(Collection::stream).forEach(each -> this.put(replicaResources, (String)each, (String)readwriteSplittingRule.getKey()));
    }

    private void put(Map<String, String> map, String key, String value) {
        map.put(key, map.containsKey(key) ? String.join((CharSequence)",", map.get(key), value) : value);
    }
}

