/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.SetInstanceStatusStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.state.StateType;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ComputeNodeStatusChangedEvent;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;

public final class SetInstanceStatusHandler
extends UpdatableRALBackendHandler<SetInstanceStatusStatement> {
    @Override
    protected void update(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((boolean)contextManager.getInstanceContext().isCluster(), () -> new UnsupportedSQLOperationException("Only allowed in cluster mode"));
        String instanceId = ((SetInstanceStatusStatement)this.getSqlStatement()).getInstanceId();
        boolean isDisable = "DISABLE".equals(((SetInstanceStatusStatement)this.getSqlStatement()).getStatus());
        if (isDisable) {
            this.checkDisablingIsValid(contextManager, instanceId);
        } else {
            this.checkEnablingIsValid(contextManager, instanceId);
        }
        contextManager.getInstanceContext().getEventBusContext().post((Object)new ComputeNodeStatusChangedEvent(isDisable ? ComputeNodeStatus.CIRCUIT_BREAK : ComputeNodeStatus.ONLINE, instanceId));
    }

    private void checkEnablingIsValid(ContextManager contextManager, String instanceId) {
        ShardingSpherePreconditions.checkState((boolean)contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId).isPresent(), () -> new UnsupportedSQLOperationException(String.format("`%s` does not exist", instanceId)));
    }

    private void checkDisablingIsValid(ContextManager contextManager, String instanceId) {
        ShardingSpherePreconditions.checkState((!contextManager.getInstanceContext().getInstance().getCurrentInstanceId().equals(instanceId) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("`%s` is the currently in use instance and cannot be disabled", instanceId)));
        ShardingSpherePreconditions.checkState((boolean)contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId).isPresent(), () -> new UnsupportedSQLOperationException(String.format("`%s` does not exist", instanceId)));
        ShardingSpherePreconditions.checkState((StateType.CIRCUIT_BREAK != ((ComputeNodeInstance)contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId).get()).getState().getCurrentState() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("`%s` compute node has been disabled", instanceId)));
    }
}

