/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.RefreshTableMetadataStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.distsql.exception.resource.EmptyResourceException;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;

public final class RefreshTableMetadataHandler
extends UpdatableRALBackendHandler<RefreshTableMetadataStatement> {
    @Override
    protected void update(ContextManager contextManager) {
        String databaseName = this.getDatabaseName();
        this.checkResources(databaseName, contextManager.getDataSourceMap(databaseName));
        String schemaName = this.getSchemaName(databaseName);
        if (((RefreshTableMetadataStatement)this.getSqlStatement()).getResourceName().isPresent()) {
            if (((RefreshTableMetadataStatement)this.getSqlStatement()).getTableName().isPresent()) {
                contextManager.reloadTable(databaseName, schemaName, (String)((RefreshTableMetadataStatement)this.getSqlStatement()).getResourceName().get(), (String)((RefreshTableMetadataStatement)this.getSqlStatement()).getTableName().get());
            } else {
                contextManager.reloadSchema(databaseName, schemaName, (String)((RefreshTableMetadataStatement)this.getSqlStatement()).getResourceName().get());
            }
            return;
        }
        if (((RefreshTableMetadataStatement)this.getSqlStatement()).getTableName().isPresent()) {
            contextManager.reloadTable(databaseName, schemaName, (String)((RefreshTableMetadataStatement)this.getSqlStatement()).getTableName().get());
        } else {
            contextManager.reloadDatabase(databaseName);
        }
    }

    private void checkResources(String databaseName, Map<String, DataSource> resources) {
        ShardingSpherePreconditions.checkState((!resources.isEmpty() ? 1 : 0) != 0, () -> new EmptyResourceException(databaseName));
        if (((RefreshTableMetadataStatement)this.getSqlStatement()).getResourceName().isPresent()) {
            String resourceName = (String)((RefreshTableMetadataStatement)this.getSqlStatement()).getResourceName().get();
            ShardingSpherePreconditions.checkState((boolean)resources.containsKey(resourceName), () -> new MissingRequiredResourcesException(databaseName, Collections.singletonList(resourceName)));
        }
    }

    private String getDatabaseName() {
        String result = this.getConnectionSession().getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(result)) {
            throw new UnknownDatabaseException(result);
        }
        return result;
    }

    private String getSchemaName(String databaseName) {
        return ((RefreshTableMetadataStatement)this.getSqlStatement()).getSchemaName().isPresent() ? (String)((RefreshTableMetadataStatement)this.getSqlStatement()).getSchemaName().get() : DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.getConnectionSession().getDatabaseType(), (String)databaseName);
    }
}

