/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.LabelInstanceStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;

public final class LabelInstanceHandler
extends UpdatableRALBackendHandler<LabelInstanceStatement> {
    @Override
    public void update(ContextManager contextManager) {
        MetaDataPersistService persistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getPersistService();
        ShardingSpherePreconditions.checkState((null != persistService && null != persistService.getRepository() && !(persistService.getRepository() instanceof StandalonePersistRepository) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Labels can only be added in cluster mode"));
        String instanceId = ((LabelInstanceStatement)this.getSqlStatement()).getInstanceId();
        Optional computeNodeInstance = contextManager.getInstanceContext().getComputeNodeInstanceById(instanceId);
        if (computeNodeInstance.isPresent()) {
            LinkedHashSet labels = new LinkedHashSet(((LabelInstanceStatement)this.getSqlStatement()).getLabels());
            if (!((LabelInstanceStatement)this.getSqlStatement()).isOverwrite()) {
                labels.addAll(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            }
            contextManager.getInstanceContext().getEventBusContext().post((Object)new LabelsChangedEvent(instanceId, new ArrayList(labels)));
        }
    }
}

