/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.YamlDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.swapper.YamlDatabaseDiscoveryRuleConfigurationSwapper;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.YamlEncryptRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesValidator;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.FileIOException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.UpdatableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.checker.DatabaseDiscoveryRuleConfigurationImportChecker;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.checker.ReadwriteSplittingRuleConfigurationImportChecker;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.checker.ShardingRuleConfigurationImportChecker;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.config.YamlReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.swapper.YamlReadwriteSplittingRuleConfigurationSwapper;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.YamlShadowRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.YamlShardingRuleConfigurationSwapper;

public final class ImportDatabaseConfigurationHandler
extends UpdatableRALBackendHandler<ImportDatabaseConfigurationStatement> {
    private final DataSourcePropertiesValidator validator = new DataSourcePropertiesValidator();
    private final ShardingRuleConfigurationImportChecker shardingRuleConfigurationImportChecker = new ShardingRuleConfigurationImportChecker();
    private final ReadwriteSplittingRuleConfigurationImportChecker readwriteSplittingRuleConfigurationImportChecker = new ReadwriteSplittingRuleConfigurationImportChecker();
    private final DatabaseDiscoveryRuleConfigurationImportChecker databaseDiscoveryRuleConfigurationImportChecker = new DatabaseDiscoveryRuleConfigurationImportChecker();
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();

    @Override
    protected void update(ContextManager contextManager) throws SQLException {
        YamlProxyDatabaseConfiguration yamlConfig;
        File file = new File(((ImportDatabaseConfigurationStatement)this.getSqlStatement()).getFilePath());
        try {
            yamlConfig = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)file, YamlProxyDatabaseConfiguration.class);
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        String databaseName = yamlConfig.getDatabaseName();
        this.checkDatabase(databaseName, file);
        this.checkDataSource(yamlConfig.getDataSources(), file);
        this.addDatabase(databaseName);
        this.addResources(databaseName, yamlConfig.getDataSources());
        try {
            this.addRules(databaseName, yamlConfig.getRules());
        }
        catch (DistSQLException ex) {
            this.dropDatabase(databaseName);
            throw ex;
        }
    }

    private void checkDatabase(String databaseName, File file) {
        Preconditions.checkNotNull((Object)databaseName, (String)"Property `databaseName` in file `%s` is required", (Object)file.getName());
        if (ProxyContext.getInstance().databaseExists(databaseName)) {
            Preconditions.checkState((boolean)ProxyContext.getInstance().getDatabase(databaseName).getResourceMetaData().getDataSources().isEmpty(), (String)"Database `%s` exists and is not empty", (Object)databaseName);
        }
    }

    private void checkDataSource(Map<String, YamlProxyDataSourceConfiguration> dataSources, File file) {
        Preconditions.checkState((!dataSources.isEmpty() ? 1 : 0) != 0, (String)"Data source configurations in file `%s` is required", (Object)file.getName());
    }

    private void addDatabase(String databaseName) throws SQLException {
        ProxyContext.getInstance().getContextManager().addDatabaseAndPersist(databaseName);
    }

    private void addResources(String databaseName, Map<String, YamlProxyDataSourceConfiguration> yamlDataSourceMap) {
        LinkedHashMap<String, DataSourceProperties> dataSourcePropsMap = new LinkedHashMap<String, DataSourceProperties>(yamlDataSourceMap.size(), 1.0f);
        for (Map.Entry<String, YamlProxyDataSourceConfiguration> entry : yamlDataSourceMap.entrySet()) {
            dataSourcePropsMap.put(entry.getKey(), DataSourcePropertiesCreator.create((String)HikariDataSource.class.getName(), (DataSourceConfiguration)this.dataSourceConfigSwapper.swap(entry.getValue())));
        }
        this.validator.validate(dataSourcePropsMap, this.getConnectionSession().getDatabaseType());
        try {
            ProxyContext.getInstance().getContextManager().addResources(databaseName, dataSourcePropsMap);
        }
        catch (SQLException ex) {
            throw new InvalidResourcesException(Collections.singleton(ex.getMessage()));
        }
    }

    private void addRules(String databaseName, Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        if (yamlRuleConfigs.isEmpty()) {
            return;
        }
        LinkedList<Object> ruleConfigs = new LinkedList<Object>();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(databaseName);
        for (YamlRuleConfiguration each : yamlRuleConfigs) {
            if (each instanceof YamlShardingRuleConfiguration) {
                ShardingRuleConfiguration shardingRuleConfig = new YamlShardingRuleConfigurationSwapper().swapToObject((YamlShardingRuleConfiguration)each);
                this.shardingRuleConfigurationImportChecker.check(database, shardingRuleConfig);
                ruleConfigs.add(shardingRuleConfig);
                continue;
            }
            if (each instanceof YamlReadwriteSplittingRuleConfiguration) {
                ReadwriteSplittingRuleConfiguration readwriteSplittingRuleConfig = new YamlReadwriteSplittingRuleConfigurationSwapper().swapToObject((YamlReadwriteSplittingRuleConfiguration)each);
                this.readwriteSplittingRuleConfigurationImportChecker.check(database, readwriteSplittingRuleConfig);
                ruleConfigs.add(readwriteSplittingRuleConfig);
                continue;
            }
            if (each instanceof YamlDatabaseDiscoveryRuleConfiguration) {
                DatabaseDiscoveryRuleConfiguration databaseDiscoveryRuleConfig = new YamlDatabaseDiscoveryRuleConfigurationSwapper().swapToObject((YamlDatabaseDiscoveryRuleConfiguration)each);
                this.databaseDiscoveryRuleConfigurationImportChecker.check(database, databaseDiscoveryRuleConfig);
                ruleConfigs.add(databaseDiscoveryRuleConfig);
                continue;
            }
            if (each instanceof YamlEncryptRuleConfiguration) {
                EncryptRuleConfiguration encryptRuleConfig = new YamlEncryptRuleConfigurationSwapper().swapToObject((YamlEncryptRuleConfiguration)each);
                ruleConfigs.add(encryptRuleConfig);
                continue;
            }
            if (!(each instanceof YamlShadowRuleConfiguration)) continue;
            ShadowRuleConfiguration shadowRuleConfig = new YamlShadowRuleConfigurationSwapper().swapToObject((YamlShadowRuleConfiguration)each);
            ruleConfigs.add(shadowRuleConfig);
        }
        database.getRuleMetaData().getConfigurations().addAll(ruleConfigs);
        ProxyContext.getInstance().getContextManager().renewMetaDataContexts(metaDataContexts);
        metaDataContexts.getPersistService().getDatabaseRulePersistService().persist(metaDataContexts.getMetaData().getActualDatabaseName(databaseName), ruleConfigs);
    }

    private void dropDatabase(String databaseName) {
        ProxyContext.getInstance().getContextManager().dropDatabaseAndPersist(databaseName);
    }
}

