/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.exception.UnsupportedVariableException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ShowVariableHandler
extends QueryableRALBackendHandler<ShowVariableStatement> {
    private static final String VARIABLE_NAME = "variable_name";
    private static final String VARIABLE_VALUE = "variable_value";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(VARIABLE_NAME, VARIABLE_VALUE);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        return this.buildSpecifiedRow(contextManager, ((ShowVariableStatement)this.getSqlStatement()).getName());
    }

    private Collection<LocalDataQueryResultRow> buildSpecifiedRow(ContextManager contextManager, String key) {
        return this.isConfigurationKey(key) ? Collections.singletonList(new LocalDataQueryResultRow(new Object[]{key.toLowerCase(), this.getConfigurationValue(contextManager, key)})) : Collections.singletonList(new LocalDataQueryResultRow(new Object[]{key.toLowerCase(), this.getSpecialValue(key)}));
    }

    private boolean isConfigurationKey(String key) {
        return ConfigurationPropertyKey.getKeyNames().contains(key);
    }

    private String getConfigurationValue(ContextManager contextManager, String key) {
        return contextManager.getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)key)).toString();
    }

    private String getSpecialValue(String key) {
        VariableEnum variable = VariableEnum.getValueOf(key);
        switch (variable) {
            case AGENT_PLUGINS_ENABLED: {
                return SystemPropertyUtil.getSystemProperty(variable.name(), Boolean.TRUE.toString());
            }
            case CACHED_CONNECTIONS: {
                if (!(this.getConnectionSession().getBackendConnection() instanceof JDBCBackendConnection)) break;
                int connectionSize = ((JDBCBackendConnection)this.getConnectionSession().getBackendConnection()).getConnectionSize();
                return String.valueOf(connectionSize);
            }
            case TRANSACTION_TYPE: {
                TransactionType transactionType = this.getConnectionSession().getTransactionStatus().getTransactionType();
                return transactionType.name();
            }
        }
        throw new UnsupportedVariableException(key);
    }
}

