/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowTableMetadataStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class ShowTableMetadataHandler
extends QueryableRALBackendHandler<ShowTableMetadataStatement> {
    private static final String SCHEMA_NAME = "schema_name";
    private static final String TABLE_NAME = "table_name";
    private static final String TYPE = "type";
    private static final String NAME = "name";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(SCHEMA_NAME, TABLE_NAME, TYPE, NAME);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        String databaseName = this.getDatabaseName();
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.getConnectionSession().getDatabaseType(), (String)this.getConnectionSession().getDatabaseName());
        ShardingSphereSchema schema = ProxyContext.getInstance().getDatabase(databaseName).getSchema(defaultSchema);
        return schema.getAllTableNames().stream().filter(each -> ((ShowTableMetadataStatement)this.getSqlStatement()).getTableNames().contains(each)).map(each -> this.buildTableRows(databaseName, schema, (String)each)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String getDatabaseName() {
        String result;
        String string = result = ((ShowTableMetadataStatement)this.getSqlStatement()).getDatabase().isPresent() ? ((DatabaseSegment)((ShowTableMetadataStatement)this.getSqlStatement()).getDatabase().get()).getIdentifier().getValue() : this.getConnectionSession().getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(result)) {
            throw new UnknownDatabaseException(result);
        }
        return result;
    }

    private Collection<LocalDataQueryResultRow> buildTableRows(String databaseName, ShardingSphereSchema schema, String tableName) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        Collection columnRows = schema.getAllColumnNames(tableName).stream().map(each -> this.buildRow(databaseName, tableName, "COLUMN", (String)each)).collect(Collectors.toList());
        Collection indexRows = schema.getTable(tableName).getIndexes().values().stream().map(ShardingSphereIndex::getName).map(each -> this.buildRow(databaseName, tableName, "INDEX", (String)each)).collect(Collectors.toList());
        result.addAll(columnRows);
        result.addAll(indexRows);
        return result;
    }

    private LocalDataQueryResultRow buildRow(String databaseName, String tableName, String type, String name) {
        return new LocalDataQueryResultRow(new Object[]{databaseName, tableName, type, name});
    }
}

