/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowModeInfoStatement;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;

public final class ShowModeInfoHandler
extends QueryableRALBackendHandler<ShowModeInfoStatement> {
    private static final String TYPE = "type";
    private static final String REPOSITORY = "repository";
    private static final String PROPS = "props";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(TYPE, REPOSITORY, PROPS);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        InstanceContext instanceContext = ProxyContext.getInstance().getContextManager().getInstanceContext();
        PersistRepositoryConfiguration repositoryConfig = instanceContext.getModeConfiguration().getRepository();
        String modeType = instanceContext.getModeConfiguration().getType();
        String repositoryType = null == repositoryConfig ? "" : repositoryConfig.getType();
        String props = null == repositoryConfig || null == repositoryConfig.getProps() ? "" : new Gson().toJson((Object)repositoryConfig.getProps());
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{modeType, repositoryType, props}));
    }
}

