/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.shardingsphere.data.pipeline.api.MigrationJobPublicAPI;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobPublicAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowMigrationProcessConfigurationStatement;
import org.apache.shardingsphere.infra.distsql.query.DatabaseDistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowMigrationProcessConfigurationQueryResultSet
implements DatabaseDistSQLResultSet {
    private static final MigrationJobPublicAPI JOB_API = PipelineJobPublicAPIFactory.getMigrationJobPublicAPI();
    private static final Gson GSON = new Gson();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        PipelineProcessConfiguration processConfig = JOB_API.showProcessConfiguration();
        LinkedList<String> row = new LinkedList<String>();
        row.add(this.getString(processConfig.getRead()));
        row.add(this.getString(processConfig.getWrite()));
        row.add(this.getString(processConfig.getStreamChannel()));
        this.data = Collections.singletonList(row).iterator();
    }

    private String getString(Object obj) {
        return null == obj ? "" : GSON.toJson(obj);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("read", "write", "stream_channel");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowMigrationProcessConfigurationStatement.class.getName();
    }
}

