/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowInstanceListStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.metadata.proxy.ProxyInstanceMetaData;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;

public final class ShowInstanceListHandler
extends QueryableRALBackendHandler<ShowInstanceListStatement> {
    private static final String ID = "instance_id";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String STATUS = "status";
    private static final String MODE_TYPE = "mode_type";
    private static final String WORKER_ID = "worker_id";
    private static final String LABELS = "labels";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(ID, HOST, PORT, STATUS, MODE_TYPE, WORKER_ID, LABELS);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        String modeType = contextManager.getInstanceContext().getModeConfiguration().getType();
        if ("Standalone".equalsIgnoreCase(modeType)) {
            return Collections.singletonList(this.buildRow(contextManager.getInstanceContext().getInstance(), modeType));
        }
        Collection instances = contextManager.getInstanceContext().getAllClusterInstances().stream().filter(each -> InstanceType.PROXY == each.getMetaData().getType()).collect(Collectors.toList());
        return instances.isEmpty() ? Collections.emptyList() : (Collection)instances.stream().filter(Objects::nonNull).map(each -> this.buildRow((ComputeNodeInstance)each, modeType)).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow buildRow(ComputeNodeInstance instance, String modeType) {
        String labels = String.join((CharSequence)",", instance.getLabels());
        InstanceMetaData instanceMetaData = instance.getMetaData();
        return new LocalDataQueryResultRow(new Object[]{instanceMetaData.getId(), instanceMetaData.getIp(), instanceMetaData instanceof ProxyInstanceMetaData ? ((ProxyInstanceMetaData)instanceMetaData).getPort() : -1, instance.getState().getCurrentState().name(), modeType, instance.getWorkerId(), labels});
    }
}

