/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowInstanceInfoStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.proxy.ProxyInstanceMetaData;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;

public final class ShowInstanceInfoHandler
extends QueryableRALBackendHandler<ShowInstanceInfoStatement> {
    private static final String ID = "instance_id";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String STATUS = "status";
    private static final String MODE_TYPE = "mode_type";
    private static final String WORKER_ID = "worker_id";
    private static final String LABELS = "labels";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(ID, HOST, PORT, STATUS, MODE_TYPE, WORKER_ID, LABELS);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        ComputeNodeInstance instance = contextManager.getInstanceContext().getInstance();
        InstanceMetaData instanceMetaData = instance.getMetaData();
        String modeType = contextManager.getInstanceContext().getModeConfiguration().getType();
        return Collections.singletonList(new LocalDataQueryResultRow(new Object[]{instanceMetaData.getId(), instanceMetaData.getIp(), instanceMetaData instanceof ProxyInstanceMetaData ? ((ProxyInstanceMetaData)instanceMetaData).getPort() : -1, instance.getState().getCurrentState().name(), modeType, instance.getWorkerId(), String.join((CharSequence)",", instance.getLabels())}));
    }
}

