/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowAllVariablesStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;

public final class ShowAllVariablesHandler
extends QueryableRALBackendHandler<ShowAllVariablesStatement> {
    private static final String VARIABLE_NAME = "variable_name";
    private static final String VARIABLE_VALUE = "variable_value";

    @Override
    protected Collection<String> getColumnNames() {
        return Arrays.asList(VARIABLE_NAME, VARIABLE_VALUE);
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        ConfigurationProperties props = contextManager.getMetaDataContexts().getMetaData().getProps();
        Collection result = ConfigurationPropertyKey.getKeyNames().stream().map(each -> new LocalDataQueryResultRow(new Object[]{each.toLowerCase(), props.getValue((Enum)ConfigurationPropertyKey.valueOf((String)each)).toString()})).collect(Collectors.toList());
        result.add(new LocalDataQueryResultRow(new Object[]{VariableEnum.AGENT_PLUGINS_ENABLED.name().toLowerCase(), SystemPropertyUtil.getSystemProperty(VariableEnum.AGENT_PLUGINS_ENABLED.name(), Boolean.TRUE.toString())}));
        if (this.getConnectionSession().getBackendConnection() instanceof JDBCBackendConnection) {
            result.add(new LocalDataQueryResultRow(new Object[]{VariableEnum.CACHED_CONNECTIONS.name().toLowerCase(), ((JDBCBackendConnection)this.getConnectionSession().getBackendConnection()).getConnectionSize()}));
        }
        result.add(new LocalDataQueryResultRow(new Object[]{VariableEnum.TRANSACTION_TYPE.name().toLowerCase(), this.getConnectionSession().getTransactionStatus().getTransactionType().name()}));
        return result;
    }
}

