/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperFactory;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.FileIOException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;

public final class ExportDatabaseConfigurationHandler
extends QueryableRALBackendHandler<ExportDatabaseConfigurationStatement> {
    @Override
    protected Collection<String> getColumnNames() {
        return Collections.singleton("result");
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        String exportedData = this.generateExportData(this.getDatabaseName());
        if (((ExportDatabaseConfigurationStatement)this.getSqlStatement()).getFilePath().isPresent()) {
            String filePath = (String)((ExportDatabaseConfigurationStatement)this.getSqlStatement()).getFilePath().get();
            this.exportToFile(filePath, exportedData);
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{String.format("Successfully exported to\uff1a'%s'", filePath)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{exportedData}));
    }

    private String getDatabaseName() {
        String result;
        String string = result = ((ExportDatabaseConfigurationStatement)this.getSqlStatement()).getDatabase().isPresent() ? ((DatabaseSegment)((ExportDatabaseConfigurationStatement)this.getSqlStatement()).getDatabase().get()).getIdentifier().getValue() : this.getConnectionSession().getDatabaseName();
        if (Strings.isNullOrEmpty((String)result)) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(result)) {
            throw new UnknownDatabaseException(result);
        }
        return result;
    }

    private String generateExportData(String databaseName) {
        StringBuilder result = new StringBuilder();
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(databaseName);
        this.appendDatabaseName(databaseName, result);
        this.appendDataSourceConfigurations(database, result);
        this.appendRuleConfigurations(database.getRuleMetaData().getConfigurations(), result);
        return result.toString();
    }

    private void appendDatabaseName(String databaseName, StringBuilder stringBuilder) {
        stringBuilder.append("databaseName").append(": ").append(databaseName).append(System.lineSeparator());
    }

    private void appendDataSourceConfigurations(ShardingSphereDatabase database, StringBuilder stringBuilder) {
        if (database.getResourceMetaData().getDataSources().isEmpty()) {
            return;
        }
        stringBuilder.append("dataSources:").append(System.lineSeparator());
        for (Map.Entry entry : database.getResourceMetaData().getDataSources().entrySet()) {
            this.appendDataSourceConfiguration((String)entry.getKey(), (DataSource)entry.getValue(), stringBuilder);
        }
    }

    private void appendDataSourceConfiguration(String name, DataSource dataSource, StringBuilder stringBuilder) {
        stringBuilder.append("  ").append(name).append(":").append(System.lineSeparator());
        DataSourceProperties dataSourceProps = DataSourcePropertiesCreator.create((DataSource)dataSource);
        dataSourceProps.getConnectionPropertySynonyms().getStandardProperties().forEach((key, value) -> stringBuilder.append("    ").append((String)key).append(": ").append(value).append(System.lineSeparator()));
        dataSourceProps.getPoolPropertySynonyms().getStandardProperties().forEach((key, value) -> stringBuilder.append("    ").append((String)key).append(": ").append(value).append(System.lineSeparator()));
    }

    private void appendRuleConfigurations(Collection<RuleConfiguration> ruleConfigs, StringBuilder stringBuilder) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        stringBuilder.append("rules:").append(System.lineSeparator());
        for (Map.Entry entry : YamlRuleConfigurationSwapperFactory.getInstanceMapByRuleConfigurations(ruleConfigs).entrySet()) {
            stringBuilder.append(YamlEngine.marshal(Collections.singletonList(((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey()))));
        }
    }

    private void exportToFile(String filePath, String exportedData) {
        File file = new File(filePath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream output = new FileOutputStream(file);){
            output.write(exportedData.getBytes());
            output.flush();
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
    }
}

